/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util.http;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.transfer.TransferCancelledException;

public class RecordingTransportListener
extends TransportListener {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
    private long dataOffset;
    private long dataLength;
    private int startedCount;
    private int progressedCount;
    private boolean cancelStart;
    private boolean cancelProgress;

    public void transportStarted(long dataOffset, long dataLength) throws TransferCancelledException {
        ++this.startedCount;
        this.progressedCount = 0;
        this.dataLength = dataLength;
        this.dataOffset = dataOffset;
        this.baos.reset();
        if (this.cancelStart) {
            throw new TransferCancelledException();
        }
    }

    public void transportProgressed(ByteBuffer data) throws TransferCancelledException {
        ++this.progressedCount;
        if (data.hasArray()) {
            this.baos.write(data.array(), data.arrayOffset() + data.position(), data.remaining());
        } else {
            byte[] arr = new byte[data.remaining()];
            data.mark();
            data.get(arr);
            data.reset();
        }
        if (this.cancelProgress) {
            throw new TransferCancelledException();
        }
    }

    public ByteArrayOutputStream getBaos() {
        return this.baos;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public long getDataLength() {
        return this.dataLength;
    }

    public int getStartedCount() {
        return this.startedCount;
    }

    public int getProgressedCount() {
        return this.progressedCount;
    }

    public boolean isCancelStart() {
        return this.cancelStart;
    }

    public boolean isCancelProgress() {
        return this.cancelProgress;
    }

    public void cancelStart() {
        this.cancelStart = true;
    }

    public void cancelProgress() {
        this.cancelProgress = true;
    }
}

