/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.test.util.http.HttpTransporterTest;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmHelper;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServer.class);
    private File repoDir;
    private boolean rangeSupport = true;
    private boolean webDav;
    private ExpectContinue expectContinue = ExpectContinue.PROPER;
    private ChecksumHeader checksumHeader;
    private Server server;
    private ServerConnector httpConnector;
    private ServerConnector httpsConnector;
    private String username;
    private String password;
    private String proxyUsername;
    private String proxyPassword;
    private final AtomicInteger connectionsToClose = new AtomicInteger(0);
    private final AtomicInteger serverErrorsBeforeWorks = new AtomicInteger(0);
    private final List<LogEntry> logEntries = Collections.synchronizedList(new ArrayList());
    private static final Pattern SIMPLE_RANGE = Pattern.compile("bytes=([0-9])+-");

    public String getHost() {
        return "localhost";
    }

    public int getHttpPort() {
        return this.httpConnector != null ? this.httpConnector.getLocalPort() : -1;
    }

    public int getHttpsPort() {
        return this.httpsConnector != null ? this.httpsConnector.getLocalPort() : -1;
    }

    public String getHttpUrl() {
        return "http://" + this.getHost() + ":" + this.getHttpPort();
    }

    public String getHttpsUrl() {
        return "https://" + this.getHost() + ":" + this.getHttpsPort();
    }

    public HttpServer addSslConnector() {
        return this.addSslConnector(true, true);
    }

    public HttpServer addSelfSignedSslConnector() {
        return this.addSslConnector(false, true);
    }

    public HttpServer addSelfSignedSslConnectorHttp2Only() {
        return this.addSslConnector(false, false);
    }

    private HttpServer addSslConnector(boolean needClientAuth, boolean needHttp11) {
        if (this.httpsConnector == null) {
            SslContextFactory.Server ssl = new SslContextFactory.Server();
            ssl.setNeedClientAuth(needClientAuth);
            if (!needClientAuth) {
                ssl.setKeyStorePath(HttpTransporterTest.KEY_STORE_SELF_SIGNED_PATH.toAbsolutePath().toString());
                ssl.setKeyStorePassword("server-pwd");
                ssl.setSniRequired(false);
            } else {
                ssl.setKeyStorePath(HttpTransporterTest.KEY_STORE_PATH.toAbsolutePath().toString());
                ssl.setKeyStorePassword("server-pwd");
                ssl.setTrustStorePath(HttpTransporterTest.TRUST_STORE_PATH.toAbsolutePath().toString());
                ssl.setTrustStorePassword("client-pwd");
                ssl.setSniRequired(false);
            }
            HttpConfiguration httpsConfig = new HttpConfiguration();
            SecureRequestCustomizer customizer = new SecureRequestCustomizer();
            customizer.setSniHostCheck(false);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)customizer);
            HttpConnectionFactory http1 = null;
            if (needHttp11) {
                http1 = new HttpConnectionFactory(httpsConfig);
            }
            HTTP2ServerConnectionFactory http2 = new HTTP2ServerConnectionFactory(httpsConfig);
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
            alpn.setDefaultProtocol(http1 != null ? http1.getProtocol() : http2.getProtocol());
            SslConnectionFactory tls = new SslConnectionFactory(ssl, alpn.getProtocol());
            this.httpsConnector = http1 != null ? new ServerConnector(this.server, new ConnectionFactory[]{tls, alpn, http2, http1}) : new ServerConnector(this.server, new ConnectionFactory[]{tls, alpn, http2});
            this.server.addConnector((Connector)this.httpsConnector);
            try {
                this.httpsConnector.start();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this;
    }

    public List<LogEntry> getLogEntries() {
        return this.logEntries;
    }

    public HttpServer setRepoDir(File repoDir) {
        this.repoDir = repoDir;
        return this;
    }

    public HttpServer setRangeSupport(boolean rangeSupport) {
        this.rangeSupport = rangeSupport;
        return this;
    }

    public HttpServer setWebDav(boolean webDav) {
        this.webDav = webDav;
        return this;
    }

    public HttpServer setExpectSupport(ExpectContinue expectContinue) {
        this.expectContinue = expectContinue;
        return this;
    }

    public HttpServer setChecksumHeader(ChecksumHeader checksumHeader) {
        this.checksumHeader = checksumHeader;
        return this;
    }

    public HttpServer setAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public HttpServer setProxyAuthentication(String username, String password) {
        this.proxyUsername = username;
        this.proxyPassword = password;
        return this;
    }

    public HttpServer setConnectionsToClose(int connectionsToClose) {
        this.connectionsToClose.set(connectionsToClose);
        return this;
    }

    public HttpServer setServerErrorsBeforeWorks(int serverErrorsBeforeWorks) {
        this.serverErrorsBeforeWorks.set(serverErrorsBeforeWorks);
        return this;
    }

    public HttpServer start() throws Exception {
        if (this.server != null) {
            return this;
        }
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)new ConnectionClosingHandler());
        handlers.addHandler((Handler)new ServerErrorHandler());
        handlers.addHandler((Handler)new LogHandler());
        handlers.addHandler((Handler)new ProxyAuthHandler());
        handlers.addHandler((Handler)new AuthHandler());
        handlers.addHandler((Handler)new RedirectHandler());
        handlers.addHandler((Handler)new RepoHandler());
        this.server = new Server();
        this.httpConnector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.httpConnector);
        this.server.setHandler((Handler)handlers);
        this.server.start();
        return this;
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
            this.httpConnector = null;
            this.httpsConnector = null;
        }
    }

    private void writeResponseBodyMessage(HttpServletResponse response, String message) throws IOException {
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(message.getBytes(StandardCharsets.UTF_8));
        }
    }

    static boolean checkBasicAuth(String credentials, String username, String password) {
        String method;
        int space;
        if (credentials != null && (space = credentials.indexOf(32)) > 0 && "basic".equalsIgnoreCase(method = credentials.substring(0, space))) {
            credentials = credentials.substring(space + 1);
            credentials = new String(Base64.getDecoder().decode(credentials), StandardCharsets.ISO_8859_1);
            int i = credentials.indexOf(58);
            if (i > 0) {
                String user = credentials.substring(0, i);
                String pass = credentials.substring(i + 1);
                if (username.equals(user) && password.equals(pass)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static enum ExpectContinue {
        FAIL,
        PROPER,
        BROKEN;

    }

    public static enum ChecksumHeader {
        NEXUS,
        XCHECKSUM;

    }

    private class ConnectionClosingHandler
    extends AbstractHandler {
        private ConnectionClosingHandler() {
        }

        public void handle(String target, Request req, HttpServletRequest request, HttpServletResponse response) {
            if (HttpServer.this.connectionsToClose.getAndDecrement() > 0) {
                Response jettyResponse = (Response)response;
                jettyResponse.getHttpChannel().getConnection().close();
            }
        }
    }

    private class ServerErrorHandler
    extends AbstractHandler {
        private ServerErrorHandler() {
        }

        public void handle(String target, Request req, HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (HttpServer.this.serverErrorsBeforeWorks.getAndDecrement() > 0) {
                response.setStatus(500);
                HttpServer.this.writeResponseBodyMessage(response, "Oops, come back later!");
            }
        }
    }

    private class LogHandler
    extends AbstractHandler {
        private LogHandler() {
        }

        public void handle(String target, Request req, HttpServletRequest request, HttpServletResponse response) {
            LOGGER.info("{} {}{}", new Object[]{req.getMethod(), req.getRequestURL(), req.getQueryString() != null ? "?" + req.getQueryString() : ""});
            TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            Enumeration en = req.getHeaderNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                StringBuilder buffer = new StringBuilder(128);
                Enumeration ien = req.getHeaders(name);
                while (ien.hasMoreElements()) {
                    if (buffer.length() > 0) {
                        buffer.append(", ");
                    }
                    buffer.append((String)ien.nextElement());
                }
                headers.put(name, buffer.toString());
            }
            HttpServer.this.logEntries.add(new LogEntry(req.getMethod(), req.getPathInfo(), Collections.unmodifiableMap(headers)));
        }
    }

    private class ProxyAuthHandler
    extends AbstractHandler {
        private ProxyAuthHandler() {
        }

        public void handle(String target, Request req, HttpServletRequest request, HttpServletResponse response) {
            if (HttpServer.this.proxyUsername != null && HttpServer.this.proxyPassword != null) {
                if (HttpServer.checkBasicAuth(request.getHeader(HttpHeader.PROXY_AUTHORIZATION.asString()), HttpServer.this.proxyUsername, HttpServer.this.proxyPassword)) {
                    return;
                }
                req.setHandled(true);
                response.setHeader(HttpHeader.PROXY_AUTHENTICATE.asString(), "basic realm=\"Test-Realm\"");
                response.setStatus(407);
            }
        }
    }

    private class AuthHandler
    extends AbstractHandler {
        private AuthHandler() {
        }

        public void handle(String target, Request req, HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (ExpectContinue.BROKEN.equals((Object)HttpServer.this.expectContinue) && "100-continue".equalsIgnoreCase(request.getHeader(HttpHeader.EXPECT.asString()))) {
                request.getInputStream();
            }
            if (HttpServer.this.username != null && HttpServer.this.password != null) {
                if (HttpServer.checkBasicAuth(request.getHeader(HttpHeader.AUTHORIZATION.asString()), HttpServer.this.username, HttpServer.this.password)) {
                    return;
                }
                req.setHandled(true);
                response.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), "basic realm=\"Test-Realm\"");
                response.setStatus(401);
            }
        }
    }

    private class RedirectHandler
    extends AbstractHandler {
        private RedirectHandler() {
        }

        public void handle(String target, Request req, HttpServletRequest request, HttpServletResponse response) {
            String path = req.getPathInfo();
            if (!path.startsWith("/redirect/")) {
                return;
            }
            req.setHandled(true);
            StringBuilder location = new StringBuilder(128);
            String scheme = req.getParameter("scheme");
            location.append(scheme != null ? scheme : req.getScheme());
            location.append("://");
            location.append(req.getServerName());
            location.append(":");
            if ("http".equalsIgnoreCase(scheme)) {
                location.append(HttpServer.this.getHttpPort());
            } else if ("https".equalsIgnoreCase(scheme)) {
                location.append(HttpServer.this.getHttpsPort());
            } else {
                location.append(req.getServerPort());
            }
            location.append("/repo").append(path.substring(9));
            response.setStatus(301);
            response.setHeader(HttpHeader.LOCATION.asString(), location.toString());
        }
    }

    private class RepoHandler
    extends AbstractHandler {
        private RepoHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request req, HttpServletRequest request, HttpServletResponse response) throws IOException {
            String path = req.getPathInfo().substring(1);
            if (!path.startsWith("repo/")) {
                return;
            }
            req.setHandled(true);
            if (ExpectContinue.FAIL.equals((Object)HttpServer.this.expectContinue) && request.getHeader(HttpHeader.EXPECT.asString()) != null) {
                response.setStatus(417);
                HttpServer.this.writeResponseBodyMessage(response, "Expectation was set to fail");
                return;
            }
            File file = new File(HttpServer.this.repoDir, path.substring(5));
            if (HttpMethod.GET.is(req.getMethod()) || HttpMethod.HEAD.is(req.getMethod())) {
                if (!file.isFile() || path.endsWith("/")) {
                    response.setStatus(404);
                    HttpServer.this.writeResponseBodyMessage(response, "Not found");
                    return;
                }
                long ifUnmodifiedSince = request.getDateHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString());
                if (ifUnmodifiedSince != -1L && file.lastModified() > ifUnmodifiedSince) {
                    response.setStatus(412);
                    HttpServer.this.writeResponseBodyMessage(response, "Precondition failed");
                    return;
                }
                long offset = 0L;
                String range = request.getHeader(HttpHeader.RANGE.asString());
                if (range != null && HttpServer.this.rangeSupport) {
                    Matcher m = SIMPLE_RANGE.matcher(range);
                    if (m.matches() && (offset = Long.parseLong(m.group(1))) >= file.length()) {
                        response.setStatus(416);
                        HttpServer.this.writeResponseBodyMessage(response, "Range not satisfiable");
                        return;
                    }
                    String encoding = request.getHeader(HttpHeader.ACCEPT_ENCODING.asString());
                    if (encoding != null && !"identity".equals(encoding) || ifUnmodifiedSince == -1L) {
                        response.setStatus(400);
                        return;
                    }
                }
                response.setStatus(offset > 0L ? 206 : 200);
                response.setDateHeader(HttpHeader.LAST_MODIFIED.asString(), file.lastModified());
                response.setHeader(HttpHeader.CONTENT_LENGTH.asString(), Long.toString(file.length() - offset));
                if (offset > 0L) {
                    response.setHeader(HttpHeader.CONTENT_RANGE.asString(), "bytes " + offset + "-" + (file.length() - 1L) + "/" + file.length());
                }
                if (HttpServer.this.checksumHeader != null) {
                    Map checksums = ChecksumAlgorithmHelper.calculate((File)file, Collections.singletonList(new Sha1ChecksumAlgorithmFactory()));
                    if (HttpServer.this.checksumHeader == ChecksumHeader.NEXUS) {
                        response.setHeader(HttpHeader.ETAG.asString(), "{SHA1{" + (String)checksums.get("SHA-1") + "}}");
                    } else if (HttpServer.this.checksumHeader == ChecksumHeader.XCHECKSUM) {
                        response.setHeader("x-checksum-sha1", (String)checksums.get("SHA-1"));
                    }
                }
                if (HttpMethod.HEAD.is(req.getMethod())) {
                    return;
                }
                FileInputStream is = null;
                try {
                    is = new FileInputStream(file);
                    if (offset > 0L) {
                        for (long skipped = is.skip(offset); skipped < offset && is.read() >= 0; ++skipped) {
                        }
                    }
                    IO.copy((InputStream)is, (OutputStream)response.getOutputStream());
                    is.close();
                    is = null;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            if (HttpMethod.PUT.is(req.getMethod())) {
                if (!HttpServer.this.webDav) {
                    file.getParentFile().mkdirs();
                }
                if (file.getParentFile().exists()) {
                    try {
                        FileOutputStream os = null;
                        try {
                            os = new FileOutputStream(file);
                            IO.copy((InputStream)request.getInputStream(), (OutputStream)os);
                            os.close();
                            os = null;
                        }
                        finally {
                            try {
                                if (os != null) {
                                    os.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (IOException e) {
                        file.delete();
                        throw e;
                    }
                    response.setStatus(204);
                } else {
                    response.setStatus(403);
                }
            } else if (HttpMethod.OPTIONS.is(req.getMethod())) {
                if (HttpServer.this.webDav) {
                    response.setHeader("DAV", "1,2");
                }
                response.setHeader(HttpHeader.ALLOW.asString(), "GET, PUT, HEAD, OPTIONS");
                response.setStatus(200);
            } else if (HttpServer.this.webDav && "MKCOL".equals(req.getMethod())) {
                if (file.exists()) {
                    response.setStatus(405);
                } else if (file.mkdir()) {
                    response.setStatus(201);
                } else {
                    response.setStatus(409);
                }
            } else {
                response.setStatus(405);
            }
        }
    }

    public static class LogEntry {
        private final String method;
        private final String path;
        private final Map<String, String> headers;

        public LogEntry(String method, String path, Map<String, String> headers) {
            this.method = method;
            this.path = path;
            this.headers = headers;
        }

        public String getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String toString() {
            return this.method + " " + this.path;
        }
    }
}

