/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.synccontext;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.PreDestroy;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.util.ChecksumUtils;
import org.eclipse.aether.util.ConfigUtils;
import org.redisson.Redisson;
import org.redisson.api.RLock;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Priority(value=0x7FFFFFFF)
@Singleton
public class RedissonSyncContextFactory
implements SyncContextFactory {
    private static final String DEFAULT_CONFIG_FILE_NAME = "maven-resolver-redisson.yaml";
    private static final String DEFAULT_REDIS_ADDRESS = "redis://localhost:6379";
    private static final String DEFAULT_CLIENT_NAME = "maven-resolver";
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String DEFAULT_DISCRIMINATOR_DIGEST = "da39a3ee5e6b4b0d3255bfef95601890afd80709";
    private static final String CONFIG_PROP_CONFIG_FILE = "aether.syncContext.redisson.configFile";
    private static final Logger LOGGER = LoggerFactory.getLogger(RedissonSyncContextFactory.class);
    private RedissonClient redissonClient;
    private String hostname;

    public RedissonSyncContextFactory() {
        LOGGER.trace("TCCL: {}", (Object)Thread.currentThread().getContextClassLoader());
        LOGGER.trace("CCL: {}", (Object)this.getClass().getClassLoader());
        this.redissonClient = this.createRedissonClient();
        this.hostname = this.getHostname();
    }

    private RedissonClient createRedissonClient() {
        Config config;
        block17: {
            String mavenConf;
            Path configFilePath = null;
            String configFile = ConfigUtils.getString((Map)System.getProperties(), null, (String[])new String[]{CONFIG_PROP_CONFIG_FILE});
            if (configFile != null && !configFile.isEmpty() && Files.notExists(configFilePath = Paths.get(configFile, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException("The specified Redisson config file does not exist: " + configFilePath);
            }
            if (configFilePath == null && (mavenConf = ConfigUtils.getString((Map)System.getProperties(), null, (String[])new String[]{"maven.conf"})) != null && !mavenConf.isEmpty() && Files.notExists(configFilePath = Paths.get(mavenConf, DEFAULT_CONFIG_FILE_NAME), new LinkOption[0])) {
                configFilePath = null;
            }
            config = null;
            if (configFilePath != null) {
                LOGGER.trace("Reading Redisson config file from '{}'", (Object)configFilePath);
                try (InputStream is = Files.newInputStream(configFilePath, new OpenOption[0]);){
                    config = Config.fromYAML((InputStream)is);
                    break block17;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read Redisson config file: " + configFilePath, e);
                }
            }
            config = new Config();
            config.useSingleServer().setAddress(DEFAULT_REDIS_ADDRESS).setClientName(DEFAULT_CLIENT_NAME);
        }
        RedissonClient redissonClient = Redisson.create((Config)config);
        LOGGER.trace("Created Redisson client with id '{}'", (Object)redissonClient.getId());
        return redissonClient;
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Failed to get hostname, using '{}'", (Object)DEFAULT_HOSTNAME, (Object)e);
            return DEFAULT_HOSTNAME;
        }
    }

    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        LOGGER.trace("Instance: {}", (Object)this);
        return new RedissonSyncContext(session, this.hostname, this.redissonClient, shared);
    }

    @PreDestroy
    public void shutdown() {
        LOGGER.trace("Shutting down Redisson client with id '{}'", (Object)this.redissonClient.getId());
        this.redissonClient.shutdown();
    }

    static class RedissonSyncContext
    implements SyncContext {
        private static final String CONFIG_PROP_DISCRIMINATOR = "aether.syncContext.redisson.discriminator";
        private static final String KEY_PREFIX = "maven:resolver:";
        private static final Logger LOGGER = LoggerFactory.getLogger(RedissonSyncContext.class);
        private final RepositorySystemSession session;
        private final String hostname;
        private final RedissonClient redissonClient;
        private final boolean shared;
        private final Map<String, RReadWriteLock> locks = new LinkedHashMap<String, RReadWriteLock>();

        private RedissonSyncContext(RepositorySystemSession session, String hostname, RedissonClient redissonClient, boolean shared) {
            this.session = session;
            this.hostname = hostname;
            this.redissonClient = redissonClient;
            this.shared = shared;
        }

        /*
         * WARNING - void declaration
         */
        public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
            void var5_9;
            CharSequence key;
            TreeSet<CharSequence> keys = new TreeSet<CharSequence>();
            if (artifacts != null) {
                for (Artifact artifact : artifacts) {
                    key = "artifact:" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
                    keys.add(key);
                }
            }
            if (metadatas != null) {
                for (Metadata metadata : metadatas) {
                    key = new StringBuilder("metadata:");
                    if (!metadata.getGroupId().isEmpty()) {
                        ((StringBuilder)key).append(metadata.getGroupId());
                        if (!metadata.getArtifactId().isEmpty()) {
                            ((StringBuilder)key).append(':').append(metadata.getArtifactId());
                            if (!metadata.getVersion().isEmpty()) {
                                ((StringBuilder)key).append(':').append(metadata.getVersion());
                            }
                        }
                    }
                    keys.add(((StringBuilder)key).toString());
                }
            }
            if (keys.isEmpty()) {
                return;
            }
            String discriminator = this.createDiscriminator();
            LOGGER.trace("Using Redis key discriminator '{}' during this session", (Object)discriminator);
            LOGGER.trace("Need {} {} lock(s) for {}", new Object[]{keys.size(), this.shared ? "read" : "write", keys});
            boolean bl = false;
            int reacquiredLockCount = 0;
            for (String string : keys) {
                RLock actualLock;
                RReadWriteLock rwLock = this.locks.get(string);
                if (rwLock == null) {
                    rwLock = this.redissonClient.getReadWriteLock(KEY_PREFIX + discriminator + ":" + string);
                    this.locks.put(string, rwLock);
                    ++var5_9;
                } else {
                    ++reacquiredLockCount;
                }
                RLock rLock = actualLock = this.shared ? rwLock.readLock() : rwLock.writeLock();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Acquiring {} lock for '{}' (currently held: {}, already locked: {})", new Object[]{this.shared ? "read" : "write", string, actualLock.getHoldCount(), actualLock.isLocked()});
                }
                actualLock.lock();
            }
            LOGGER.trace("Total new locks acquired: {}, total existing locks reacquired: {}", (Object)((int)var5_9), (Object)reacquiredLockCount);
        }

        private String createDiscriminator() {
            String discriminator = ConfigUtils.getString((RepositorySystemSession)this.session, null, (String[])new String[]{CONFIG_PROP_DISCRIMINATOR});
            if (discriminator == null || discriminator.isEmpty()) {
                File basedir = this.session.getLocalRepository().getBasedir();
                discriminator = this.hostname + ":" + basedir;
                try {
                    Map checksums = ChecksumUtils.calc((byte[])discriminator.toString().getBytes(StandardCharsets.UTF_8), Collections.singletonList("SHA-1"));
                    Object checksum = checksums.get("SHA-1");
                    if (checksum instanceof Exception) {
                        throw (Exception)checksum;
                    }
                    return String.valueOf(checksum);
                }
                catch (Exception e) {
                    LOGGER.trace("Failed to calculate discriminator digest, using '{}'", (Object)RedissonSyncContextFactory.DEFAULT_DISCRIMINATOR_DIGEST, (Object)e);
                    return RedissonSyncContextFactory.DEFAULT_DISCRIMINATOR_DIGEST;
                }
            }
            return discriminator;
        }

        public void close() {
            if (this.locks.isEmpty()) {
                return;
            }
            LinkedList<String> keys = new LinkedList<String>(this.locks.keySet());
            Iterator keysIter = keys.descendingIterator();
            while (keysIter.hasNext()) {
                RLock actualLock;
                String key = (String)keysIter.next();
                RReadWriteLock rwLock = this.locks.get(key);
                RLock rLock = actualLock = this.shared ? rwLock.readLock() : rwLock.writeLock();
                while (actualLock.getHoldCount() > 0) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Releasing {} lock for '{}' (currently held: {})", new Object[]{this.shared ? "read" : "write", key, actualLock.getHoldCount()});
                    }
                    actualLock.unlock();
                }
            }
            LOGGER.trace("Total locks released: {}", (Object)this.locks.size());
            this.locks.clear();
        }
    }
}

