/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.support;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.eclipse.aether.named.support.NamedLockSupport;

public class AdaptedSemaphoreNamedLock
extends NamedLockSupport {
    private static final int NONE = 0;
    private static final int SHARED = 1;
    private static final int EXCLUSIVE = Integer.MAX_VALUE;
    private final ThreadLocal<Deque<Integer>> threadPerms = ThreadLocal.withInitial(ArrayDeque::new);
    private final AdaptedSemaphore semaphore;

    public AdaptedSemaphoreNamedLock(String name, NamedLockFactorySupport factory, AdaptedSemaphore semaphore) {
        super(name, factory);
        this.semaphore = semaphore;
    }

    @Override
    protected boolean doLockShared(long time, TimeUnit unit) throws InterruptedException {
        Deque<Integer> perms = this.threadPerms.get();
        if (!perms.isEmpty()) {
            perms.push(0);
            return true;
        }
        if (this.semaphore.tryAcquire(1, time, unit)) {
            perms.push(1);
            return true;
        }
        return false;
    }

    @Override
    protected boolean doLockExclusively(long time, TimeUnit unit) throws InterruptedException {
        Deque<Integer> perms = this.threadPerms.get();
        if (!perms.isEmpty()) {
            if (perms.contains(Integer.MAX_VALUE)) {
                perms.push(0);
                return true;
            }
            return false;
        }
        if (this.semaphore.tryAcquire(Integer.MAX_VALUE, time, unit)) {
            perms.push(Integer.MAX_VALUE);
            return true;
        }
        return false;
    }

    @Override
    protected void doUnlock() {
        Deque<Integer> steps = this.threadPerms.get();
        if (steps.isEmpty()) {
            throw new IllegalStateException("Wrong API usage: unlock without lock");
        }
        int step = steps.pop();
        if (step > 0) {
            this.semaphore.release(step);
        }
    }

    public static interface AdaptedSemaphore {
        public boolean tryAcquire(int var1, long var2, TimeUnit var4) throws InterruptedException;

        public void release(int var1);
    }
}

