/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.ipc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.aether.named.ipc.ByteChannelWrapper;
import org.eclipse.aether.named.ipc.IpcClient;
import org.eclipse.aether.named.ipc.SocketFamily;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class IpcServer {
    public static final String SYSTEM_PROP_NO_FORK = "aether.named.ipc.nofork";
    public static final boolean DEFAULT_NO_FORK = false;
    public static final String SYSTEM_PROP_IDLE_TIMEOUT = "aether.named.ipc.idleTimeout";
    public static final int DEFAULT_IDLE_TIMEOUT = 60;
    public static final String SYSTEM_PROP_FAMILY = "aether.named.ipc.family";
    public static final String DEFAULT_FAMILY = "unix";
    public static final String SYSTEM_PROP_NO_NATIVE = "aether.named.ipc.nonative";
    public static final boolean DEFAULT_NO_NATIVE = true;
    public static final String SYSTEM_PROP_NATIVE_NAME = "aether.named.ipc.nativeName";
    public static final String DEFAULT_NATIVE_NAME = "ipc-sync";
    public static final String SYSTEM_PROP_DEBUG = "aether.named.ipc.debug";
    public static final boolean DEFAULT_DEBUG = false;
    private final ServerSocketChannel serverSocket;
    private final Map<SocketChannel, Thread> clients = new HashMap<SocketChannel, Thread>();
    private final AtomicInteger counter = new AtomicInteger();
    private final Map<String, Lock> locks = new ConcurrentHashMap<String, Lock>();
    private final Map<String, Context> contexts = new ConcurrentHashMap<String, Context>();
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("aether.named.ipc.debug", Boolean.toString(false)));
    private final long idleTimeout;
    private volatile long lastUsed;
    private volatile boolean closing;

    public IpcServer(SocketFamily family) throws IOException {
        this.serverSocket = family.openServerSocket();
        long timeout = TimeUnit.SECONDS.toNanos(60L);
        String str = System.getProperty(SYSTEM_PROP_IDLE_TIMEOUT);
        if (str != null) {
            try {
                TimeUnit unit = TimeUnit.SECONDS;
                if (str.endsWith("ms")) {
                    unit = TimeUnit.MILLISECONDS;
                    str = str.substring(0, str.length() - 2);
                }
                long dur = Long.parseLong(str);
                timeout = unit.toNanos(dur);
            }
            catch (NumberFormatException e) {
                IpcServer.error("Property aether.named.ipc.idleTimeout specified with invalid value: " + str, e);
            }
        }
        this.idleTimeout = timeout;
    }

    public static void main(String[] args) throws Exception {
        try {
            Signal.handle(new Signal("INT"), SignalHandler.SIG_IGN);
            if (IpcClient.IS_WINDOWS) {
                Signal.handle(new Signal("TSTP"), SignalHandler.SIG_IGN);
            }
        }
        catch (Throwable t) {
            IpcServer.error("Unable to ignore INT and TSTP signals", t);
        }
        String family = args[0];
        String tmpAddress = args[1];
        String rand = args[2];
        IpcServer.runServer(SocketFamily.valueOf(family), tmpAddress, rand);
    }

    static IpcServer runServer(SocketFamily family, String tmpAddress, String rand) throws IOException {
        IpcServer server = new IpcServer(family);
        IpcServer.run(server::run, false);
        String address = SocketFamily.toString(server.getLocalAddress());
        SocketAddress socketAddress = SocketFamily.fromString(tmpAddress);
        try (SocketChannel socket = SocketChannel.open(socketAddress);
             DataOutputStream dos = new DataOutputStream(Channels.newOutputStream(socket));){
            dos.writeUTF(rand);
            dos.writeUTF(address);
            dos.flush();
        }
        return server;
    }

    private static void debug(String msg, Object ... args) {
        if (DEBUG) {
            System.out.printf("[ipc] [debug] " + msg + "\n", args);
        }
    }

    private static void info(String msg, Object ... args) {
        System.out.printf("[ipc] [info] " + msg + "\n", args);
    }

    private static void error(String msg, Throwable t) {
        System.out.println("[ipc] [error] " + msg);
        t.printStackTrace(System.out);
    }

    private static void run(Runnable runnable, boolean daemon) {
        Thread thread = new Thread(runnable);
        if (daemon) {
            thread.setDaemon(true);
        }
        thread.start();
    }

    public SocketAddress getLocalAddress() throws IOException {
        return this.serverSocket.getLocalAddress();
    }

    public void run() {
        block3: {
            try {
                IpcServer.info("IpcServer started at %s", this.getLocalAddress().toString());
                this.use();
                IpcServer.run(this::expirationCheck, true);
                while (!this.closing) {
                    SocketChannel socket = this.serverSocket.accept();
                    IpcServer.run(() -> this.client(socket), false);
                }
            }
            catch (Throwable t) {
                if (this.closing) break block3;
                IpcServer.error("Error running sync server loop", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void client(SocketChannel socket) {
        block59: {
            Object wrapper2222222222;
            ConcurrentHashMap<String, Context> clientContexts;
            int c;
            block57: {
                Map<SocketChannel, Thread> map = this.clients;
                synchronized (map) {
                    this.clients.put(socket, Thread.currentThread());
                    c = this.clients.size();
                }
                IpcServer.info("New client connected (%d connected)", c);
                this.use();
                clientContexts = new ConcurrentHashMap<String, Context>();
                wrapper2222222222 = new ByteChannelWrapper(socket);
                DataInputStream input = new DataInputStream(Channels.newInputStream((ReadableByteChannel)wrapper2222222222));
                DataOutputStream output = new DataOutputStream(Channels.newOutputStream((WritableByteChannel)wrapper2222222222));
                while (!this.closing) {
                    String command;
                    int requestId = input.readInt();
                    int sz = input.readInt();
                    ArrayList<String> request = new ArrayList<String>(sz);
                    for (int i = 0; i < sz; ++i) {
                        request.add(input.readUTF());
                    }
                    if (request.isEmpty()) {
                        throw new IOException("Received invalid request");
                    }
                    this.use();
                    switch (command = (String)request.remove(0)) {
                        case "request-context": {
                            if (request.size() != 1) {
                                throw new IOException("Expected one argument for " + command + " but got " + String.valueOf(request));
                            }
                            boolean shared = Boolean.parseBoolean((String)request.remove(0));
                            Context context2 = new Context(shared);
                            this.contexts.put(context2.id, context2);
                            clientContexts.put(context2.id, context2);
                            DataOutputStream dataOutputStream = output;
                            synchronized (dataOutputStream) {
                                IpcServer.debug("Created context %s", context2.id);
                                output.writeInt(requestId);
                                output.writeInt(2);
                                output.writeUTF("response-context");
                                output.writeUTF(context2.id);
                                output.flush();
                                break;
                            }
                        }
                        case "request-acquire": {
                            if (request.size() < 1) {
                                throw new IOException("Expected at least one argument for " + command + " but got " + String.valueOf(request));
                            }
                            String contextId = (String)request.remove(0);
                            Context context2 = this.contexts.get(contextId);
                            if (context2 == null) {
                                throw new IOException("Unknown context: " + contextId + ". Known contexts = " + String.valueOf(this.contexts.keySet()));
                            }
                            context2.lock(request).thenRun(() -> {
                                try {
                                    DataOutputStream dataOutputStream = output;
                                    synchronized (dataOutputStream) {
                                        IpcServer.debug("Locking in context %s", context.id);
                                        output.writeInt(requestId);
                                        output.writeInt(1);
                                        output.writeUTF("response-acquire");
                                        output.flush();
                                    }
                                }
                                catch (IOException e) {
                                    try {
                                        socket.close();
                                    }
                                    catch (IOException ioException) {
                                        e.addSuppressed(ioException);
                                    }
                                    IpcServer.error("Error writing lock response", e);
                                }
                            });
                            break;
                        }
                        case "request-close": {
                            if (request.size() != 1) {
                                throw new IOException("Expected one argument for " + command + " but got " + String.valueOf(request));
                            }
                            String contextId = (String)request.remove(0);
                            Context context2 = this.contexts.remove(contextId);
                            clientContexts.remove(contextId);
                            if (context2 == null) {
                                throw new IOException("Unknown context: " + contextId + ". Known contexts = " + String.valueOf(this.contexts.keySet()));
                            }
                            context2.unlock();
                            DataOutputStream dataOutputStream = output;
                            synchronized (dataOutputStream) {
                                IpcServer.debug("Closing context %s", context2.id);
                                output.writeInt(requestId);
                                output.writeInt(1);
                                output.writeUTF("response-close");
                                output.flush();
                                break;
                            }
                        }
                        case "request-stop": {
                            if (request.size() != 0) {
                                throw new IOException("Expected zero argument for " + command + " but got " + String.valueOf(request));
                            }
                            DataOutputStream dataOutputStream = output;
                            synchronized (dataOutputStream) {
                                IpcServer.debug("Stopping server", new Object[0]);
                                output.writeInt(requestId);
                                output.writeInt(1);
                                output.writeUTF("response-stop");
                                output.flush();
                            }
                            this.close();
                            break;
                        }
                        default: {
                            throw new IOException("Unknown request: " + (String)request.get(0));
                        }
                    }
                }
                if (this.closing) break block57;
                IpcServer.info("Client disconnecting...", new Object[0]);
            }
            clientContexts.values().forEach(context -> {
                this.contexts.remove(context.id);
                context.unlock();
            });
            try {
                socket.close();
            }
            catch (IOException wrapper2222222222) {
                // empty catch block
            }
            wrapper2222222222 = this.clients;
            synchronized (wrapper2222222222) {
                this.clients.remove(socket);
                c = this.clients.size();
            }
            if (!this.closing) {
                IpcServer.info("%d clients left", c);
            }
            break block59;
            catch (Throwable t) {
                block58: {
                    try {
                        if (!this.closing) {
                            IpcServer.error("Error processing request", t);
                        }
                        if (this.closing) break block58;
                    }
                    catch (Throwable throwable) {
                        if (!this.closing) {
                            IpcServer.info("Client disconnecting...", new Object[0]);
                        }
                        clientContexts.values().forEach(context -> {
                            this.contexts.remove(context.id);
                            context.unlock();
                        });
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        Map<SocketChannel, Thread> map = this.clients;
                        synchronized (map) {
                            this.clients.remove(socket);
                            c = this.clients.size();
                        }
                        if (!this.closing) {
                            IpcServer.info("%d clients left", c);
                        }
                        throw throwable;
                    }
                    IpcServer.info("Client disconnecting...", new Object[0]);
                }
                clientContexts.values().forEach(context -> {
                    this.contexts.remove(context.id);
                    context.unlock();
                });
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Map<SocketChannel, Thread> map = this.clients;
                synchronized (map) {
                    this.clients.remove(socket);
                    c = this.clients.size();
                }
                if (!this.closing) {
                    IpcServer.info("%d clients left", c);
                }
            }
        }
    }

    private void use() {
        this.lastUsed = System.nanoTime();
    }

    private void expirationCheck() {
        while (true) {
            long current;
            long left;
            if ((left = this.lastUsed + this.idleTimeout - (current = System.nanoTime())) < 0L) {
                IpcServer.info("IpcServer expired, closing", new Object[0]);
                this.close();
                break;
            }
            try {
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(left));
            }
            catch (InterruptedException e) {
                IpcServer.info("IpcServer expiration check interrupted, closing", new Object[0]);
                this.close();
                break;
            }
        }
    }

    void close() {
        this.closing = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            IpcServer.error("Error closing server socket", e);
        }
        this.clients.forEach((s, t) -> {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            t.interrupt();
        });
    }

    class Context {
        final String id;
        final boolean shared;
        final List<String> locks = new CopyOnWriteArrayList<String>();

        Context(boolean shared) {
            this.id = String.format("%08x", IpcServer.this.counter.incrementAndGet());
            this.shared = shared;
        }

        public CompletableFuture<?> lock(List<String> keys) {
            this.locks.addAll(keys);
            CompletableFuture[] futures = (CompletableFuture[])keys.stream().map(k -> IpcServer.this.locks.computeIfAbsent((String)k, Lock::new)).map(l -> l.lock(this)).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(futures);
        }

        public void unlock() {
            this.locks.stream().map(k -> IpcServer.this.locks.computeIfAbsent((String)k, Lock::new)).forEach(l -> l.unlock(this));
        }
    }

    static class Lock {
        final String key;
        List<Context> holders;
        List<Waiter> waiters;

        Lock(String key) {
            this.key = key;
        }

        public synchronized CompletableFuture<Void> lock(Context context) {
            if (this.holders == null) {
                this.holders = new ArrayList<Context>();
            }
            if (this.holders.isEmpty() || this.holders.get((int)0).shared && context.shared) {
                this.holders.add(context);
                return CompletableFuture.completedFuture(null);
            }
            if (this.waiters == null) {
                this.waiters = new ArrayList<Waiter>();
            }
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.waiters.add(new Waiter(context, future));
            return future;
        }

        public synchronized void unlock(Context context) {
            block3: {
                block2: {
                    if (!this.holders.remove(context)) break block2;
                    while (this.waiters != null && !this.waiters.isEmpty() && (this.holders.isEmpty() || this.holders.get((int)0).shared && this.waiters.get((int)0).context.shared)) {
                        Waiter waiter = this.waiters.remove(0);
                        this.holders.add(waiter.context);
                        waiter.future.complete(null);
                    }
                    break block3;
                }
                if (this.waiters == null) break block3;
                Iterator<Waiter> it = this.waiters.iterator();
                while (it.hasNext()) {
                    Waiter waiter = it.next();
                    if (waiter.context != context) continue;
                    it.remove();
                    waiter.future.cancel(false);
                }
            }
        }
    }

    static class Waiter {
        final Context context;
        final CompletableFuture<Void> future;

        Waiter(Context context, CompletableFuture<Void> future) {
            this.context = context;
            this.future = future;
        }
    }
}

