/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.ipc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.Channels;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.aether.named.ipc.ByteChannelWrapper;
import org.eclipse.aether.named.ipc.SocketFamily;

public class IpcClient {
    static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
    volatile boolean initialized;
    Path lockPath;
    Path logPath;
    Path syncPath;
    SocketChannel socket;
    DataOutputStream output;
    DataInputStream input;
    Thread receiver;
    AtomicInteger requestId = new AtomicInteger();
    Map<Integer, CompletableFuture<List<String>>> responses = new ConcurrentHashMap<Integer, CompletableFuture<List<String>>>();

    IpcClient(Path lockPath, Path logPath, Path syncPath) {
        this.lockPath = lockPath;
        this.logPath = logPath;
        this.syncPath = syncPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureInitialized() throws IOException {
        if (!this.initialized) {
            IpcClient ipcClient = this;
            synchronized (ipcClient) {
                if (!this.initialized) {
                    this.socket = this.createClient();
                    ByteChannelWrapper wrapper = new ByteChannelWrapper(this.socket);
                    this.input = new DataInputStream(Channels.newInputStream(wrapper));
                    this.output = new DataOutputStream(Channels.newOutputStream(wrapper));
                    this.receiver = new Thread(this::receive);
                    this.receiver.setDaemon(true);
                    this.receiver.start();
                    this.initialized = true;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    SocketChannel createClient() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 13[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getJarPath(Class<?> clazz) {
        String classpath;
        String className = clazz.getName().replace('.', '/') + ".class";
        String url = clazz.getClassLoader().getResource(className).toString();
        if (url.startsWith("jar:")) {
            if (!(url = url.substring("jar:".length(), url.indexOf("!/"))).startsWith("file:")) throw new IllegalStateException();
            classpath = url.substring("file:".length());
        } else {
            if (!url.startsWith("file:")) throw new IllegalStateException();
            classpath = url.substring("file:".length(), url.indexOf(className));
        }
        if (!IS_WINDOWS) return classpath;
        if (!classpath.startsWith("/")) return classpath.replace('/', '\\');
        classpath = classpath.substring(1);
        return classpath.replace('/', '\\');
    }

    void receive() {
        try {
            while (true) {
                int id = this.input.readInt();
                int sz = this.input.readInt();
                ArrayList<String> s = new ArrayList<String>(sz);
                for (int i = 0; i < sz; ++i) {
                    s.add(this.input.readUTF());
                }
                CompletableFuture<List<String>> f = this.responses.remove(id);
                if (f == null || s.isEmpty()) {
                    throw new IllegalStateException("Protocol error");
                }
                f.complete(s);
            }
        }
        catch (EOFException id) {
        }
        catch (Exception e) {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> send(List<String> request, long time, TimeUnit unit) throws TimeoutException, IOException {
        this.ensureInitialized();
        int id = this.requestId.incrementAndGet();
        CompletableFuture response = new CompletableFuture();
        this.responses.put(id, response);
        DataOutputStream dataOutputStream = this.output;
        synchronized (dataOutputStream) {
            this.output.writeInt(id);
            this.output.writeInt(request.size());
            for (String s : request) {
                this.output.writeUTF(s);
            }
            this.output.flush();
        }
        try {
            return (List)response.get(time, unit);
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Interrupted").initCause(e);
        }
        catch (ExecutionException e) {
            throw new IOException("Execution error", e);
        }
    }

    void close() {
        this.close(new IOException("Closing"));
    }

    synchronized void close(Throwable e) {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException t) {
                e.addSuppressed(t);
            }
            this.socket = null;
            this.input = null;
            this.output = null;
        }
        if (this.receiver != null) {
            this.receiver.interrupt();
            try {
                this.receiver.join(1000L);
            }
            catch (InterruptedException t) {
                e.addSuppressed(t);
            }
        }
        this.responses.values().forEach(f -> f.completeExceptionally(e));
        this.responses.clear();
    }

    String newContext(boolean shared, long time, TimeUnit unit) throws TimeoutException {
        RuntimeException error = new RuntimeException("Unable to create new sync context");
        for (int i = 0; i < 2; ++i) {
            try {
                List<String> response = this.send(Arrays.asList("request-context", Boolean.toString(shared)), time, unit);
                if (response.size() != 2 || !"response-context".equals(response.get(0))) {
                    throw new IOException("Unexpected response: " + String.valueOf(response));
                }
                return response.get(1);
            }
            catch (TimeoutException e) {
                throw e;
            }
            catch (Exception e) {
                this.close(e);
                error.addSuppressed(e);
                continue;
            }
        }
        throw error;
    }

    void lock(String contextId, Collection<String> keys, long time, TimeUnit unit) throws TimeoutException {
        try {
            ArrayList<String> req = new ArrayList<String>(keys.size() + 2);
            req.add("request-acquire");
            req.add(contextId);
            req.addAll(keys);
            List<String> response = this.send(req, time, unit);
            if (response.size() != 1 || !"response-acquire".equals(response.get(0))) {
                throw new IOException("Unexpected response: " + String.valueOf(response));
            }
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            this.close(e);
            throw new RuntimeException("Unable to perform lock (contextId = " + contextId + ")", e);
        }
    }

    void unlock(String contextId) {
        try {
            List<String> response = this.send(Arrays.asList("request-close", contextId), Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            if (response.size() != 1 || !"response-close".equals(response.get(0))) {
                throw new IOException("Unexpected response: " + String.valueOf(response));
            }
        }
        catch (Exception e) {
            this.close(e);
            throw new RuntimeException("Unable to unlock (contextId = " + contextId + ")", e);
        }
    }

    void stopServer() {
        try {
            List<String> response = this.send(Arrays.asList("request-stop"), Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            if (response.size() != 1 || !"response-stop".equals(response.get(0))) {
                throw new IOException("Unexpected response: " + String.valueOf(response));
            }
        }
        catch (Exception e) {
            this.close(e);
            throw new RuntimeException("Unable to stop server", e);
        }
    }

    public String toString() {
        return "IpcClient{lockPath=" + String.valueOf(this.lockPath) + ",syncServerPath=" + String.valueOf(this.syncPath) + ",address='" + this.getAddress() + "'}";
    }

    private String getAddress() {
        try {
            return SocketFamily.toString(this.socket.getLocalAddress());
        }
        catch (IOException e) {
            return "[not bound]";
        }
    }

    private static /* synthetic */ String[] lambda$createClient$0(ServerSocketChannel ss) throws Exception {
        SocketChannel s = ss.accept();
        DataInputStream dis = new DataInputStream(Channels.newInputStream(s));
        String rand2 = dis.readUTF();
        String addr2 = dis.readUTF();
        return new String[]{rand2, addr2};
    }
}

