/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.ipc;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;

public enum SocketFamily {
    inet,
    unix;


    public ServerSocketChannel openServerSocket() throws IOException {
        switch (this.ordinal()) {
            case 0: {
                return ServerSocketChannel.open().bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), 0);
            }
            case 1: {
                return ServerSocketChannel.open(StandardProtocolFamily.UNIX).bind(null, 0);
            }
        }
        throw new IllegalStateException();
    }

    public static SocketAddress fromString(String str) {
        if (str.startsWith("inet:")) {
            InetAddress addr;
            String s = str.substring("inet:".length());
            int ic = s.lastIndexOf(58);
            String ia = s.substring(0, ic);
            int is = ia.indexOf(47);
            String h = ia.substring(0, is);
            String a = ia.substring(is + 1);
            String p = s.substring(ic + 1);
            if ("<unresolved>".equals(a)) {
                return InetSocketAddress.createUnresolved(h, Integer.parseInt(p));
            }
            if (a.indexOf(46) > 0) {
                String[] as = a.split("\\.");
                if (as.length != 4) {
                    throw new IllegalArgumentException("Unsupported socket address: '" + str + "'");
                }
                byte[] ab = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    ab[i] = (byte)Integer.parseInt(as[i]);
                }
                try {
                    addr = InetAddress.getByAddress(h.isEmpty() ? null : h, ab);
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("Unsupported address: " + str, e);
                }
            } else {
                throw new IllegalArgumentException("Unsupported address: " + str);
            }
            return new InetSocketAddress(addr, Integer.parseInt(p));
        }
        if (str.startsWith("unix:")) {
            return UnixDomainSocketAddress.of(str.substring("unix:".length()));
        }
        throw new IllegalArgumentException("Unsupported socket address: '" + str + "'");
    }

    public static String toString(SocketAddress address) {
        switch (SocketFamily.familyOf(address).ordinal()) {
            case 0: {
                Object formatted;
                InetSocketAddress isa = (InetSocketAddress)address;
                String host = isa.getHostString();
                InetAddress addr = isa.getAddress();
                int port = isa.getPort();
                if (addr == null) {
                    formatted = host + "/<unresolved>";
                } else {
                    formatted = addr.toString();
                    if (addr instanceof Inet6Address) {
                        int i = ((String)formatted).lastIndexOf("/");
                        formatted = ((String)formatted).substring(0, i + 1) + "[" + ((String)formatted).substring(i + 1) + "]";
                    }
                }
                return "inet:" + (String)formatted + ":" + port;
            }
            case 1: {
                return "unix:" + address.toString().replace('\\', '/');
            }
        }
        throw new IllegalArgumentException("Unsupported socket address: '" + String.valueOf(address) + "'");
    }

    public static SocketFamily familyOf(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            return inet;
        }
        if ("java.net.UnixDomainSocketAddress".equals(address.getClass().getName())) {
            return unix;
        }
        throw new IllegalArgumentException("Unsupported socket address '" + String.valueOf(address) + "'");
    }
}

