/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.ipc;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.named.NamedLock;
import org.eclipse.aether.named.NamedLockKey;
import org.eclipse.aether.named.ipc.IpcClient;
import org.eclipse.aether.named.ipc.IpcNamedLock;
import org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.eclipse.aether.named.support.NamedLockSupport;
import org.eclipse.aether.util.StringDigestUtil;

@Singleton
@Named(value="ipc")
public class IpcNamedLockFactory
extends NamedLockFactorySupport {
    public static final String NAME = "ipc";
    protected final IpcClient client;

    @Inject
    public IpcNamedLockFactory() {
        this(Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ipc-sync"));
    }

    public IpcNamedLockFactory(Path ipcHome) {
        Objects.requireNonNull(ipcHome);
        Path repository = ipcHome.resolve("repository");
        Path logPath = ipcHome.resolve("log");
        Path syncPath = null;
        this.client = new IpcClient(repository, logPath, syncPath);
    }

    protected NamedLock doGetLock(Collection<NamedLockKey> keys) {
        StringDigestUtil sha1 = StringDigestUtil.sha1();
        keys.forEach(k -> sha1.update(k.name()));
        NamedLockKey key = NamedLockKey.of((String)sha1.digest(), (Collection)keys.stream().map(NamedLockKey::resources).flatMap(Collection::stream).collect(Collectors.toList()));
        return this.getLockAndRefTrack(key, () -> new IpcNamedLock(key, this, this.client, keys.stream().map(NamedLockKey::name).collect(Collectors.toList())));
    }

    protected NamedLockSupport createLock(NamedLockKey key) {
        throw new IllegalStateException("should not get here");
    }

    protected void doShutdown() {
        this.client.close();
    }
}

