/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.ipc;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.aether.named.NamedLockKey;
import org.eclipse.aether.named.ipc.IpcClient;
import org.eclipse.aether.named.ipc.IpcNamedLockFactory;
import org.eclipse.aether.named.support.LockUpgradeNotSupportedException;
import org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.eclipse.aether.named.support.NamedLockSupport;

class IpcNamedLock
extends NamedLockSupport {
    final IpcClient client;
    final Collection<String> keys;
    final ThreadLocal<ArrayDeque<Ctx>> contexts;

    IpcNamedLock(NamedLockKey key, IpcNamedLockFactory factory, IpcClient client, Collection<String> keys) {
        super(key, (NamedLockFactorySupport)factory);
        this.client = client;
        this.keys = keys;
        this.contexts = ThreadLocal.withInitial(ArrayDeque::new);
    }

    public boolean doLockShared(long time, TimeUnit unit) {
        ArrayDeque<Ctx> contexts = this.contexts.get();
        if (!contexts.isEmpty()) {
            contexts.push(new Ctx(false, null, true));
            return true;
        }
        try {
            String contextId = this.client.newContext(true, time, unit);
            this.client.lock(Objects.requireNonNull(contextId), this.keys, time, unit);
            contexts.push(new Ctx(true, contextId, true));
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public boolean doLockExclusively(long time, TimeUnit unit) {
        ArrayDeque<Ctx> contexts = this.contexts.get();
        if (contexts.stream().anyMatch(c -> c.shared)) {
            throw new LockUpgradeNotSupportedException((NamedLockSupport)this);
        }
        if (!contexts.isEmpty()) {
            contexts.push(new Ctx(false, null, false));
            return true;
        }
        try {
            String contextId = this.client.newContext(false, time, unit);
            this.client.lock(Objects.requireNonNull(contextId), this.keys, time, unit);
            contexts.push(new Ctx(true, contextId, false));
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public void doUnlock() {
        ArrayDeque<Ctx> contexts = this.contexts.get();
        if (contexts.isEmpty()) {
            throw new IllegalStateException("improper boxing");
        }
        Ctx ctx = contexts.pop();
        if (ctx.acted) {
            this.client.unlock(ctx.contextId);
        }
    }

    private static final class Ctx {
        private final boolean acted;
        private final String contextId;
        private final boolean shared;

        private Ctx(boolean acted, String contextId, boolean shared) {
            this.acted = acted;
            this.contextId = contextId;
            this.shared = shared;
        }
    }
}

