/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.ISemaphore;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.named.NamedLock;
import org.eclipse.aether.named.NamedLockKey;
import org.eclipse.aether.named.hazelcast.HazelcastSemaphoreProvider;
import org.eclipse.aether.named.support.AdaptedSemaphoreNamedLock;
import org.eclipse.aether.named.support.NamedLockFactorySupport;

@Deprecated
public class HazelcastSemaphoreNamedLockFactory
extends NamedLockFactorySupport {
    protected final HazelcastInstance hazelcastInstance;
    protected final boolean manageHazelcast;
    private final HazelcastSemaphoreProvider hazelcastSemaphoreProvider;
    private final ConcurrentMap<NamedLockKey, ISemaphore> semaphores;

    public HazelcastSemaphoreNamedLockFactory(HazelcastInstance hazelcastInstance, boolean manageHazelcast, HazelcastSemaphoreProvider hazelcastSemaphoreProvider) {
        this.hazelcastInstance = Objects.requireNonNull(hazelcastInstance);
        this.manageHazelcast = manageHazelcast;
        this.hazelcastSemaphoreProvider = Objects.requireNonNull(hazelcastSemaphoreProvider);
        this.semaphores = new ConcurrentHashMap<NamedLockKey, ISemaphore>();
    }

    protected AdaptedSemaphoreNamedLock createLock(NamedLockKey key) {
        ISemaphore semaphore = this.semaphores.computeIfAbsent(key, k -> this.hazelcastSemaphoreProvider.acquireSemaphore(this.hazelcastInstance, key));
        return new AdaptedSemaphoreNamedLock(key, (NamedLockFactorySupport)this, (AdaptedSemaphoreNamedLock.AdaptedSemaphore)new HazelcastSemaphore(semaphore));
    }

    protected void destroyLock(NamedLock namedLock) {
        if (namedLock instanceof AdaptedSemaphoreNamedLock) {
            NamedLockKey key = namedLock.key();
            this.hazelcastSemaphoreProvider.releaseSemaphore(this.hazelcastInstance, key, (ISemaphore)this.semaphores.remove(key));
        }
    }

    protected void doShutdown() {
        if (this.manageHazelcast) {
            this.hazelcastInstance.shutdown();
        }
    }

    private static final class HazelcastSemaphore
    implements AdaptedSemaphoreNamedLock.AdaptedSemaphore {
        private final ISemaphore semaphore;

        private HazelcastSemaphore(ISemaphore semaphore) {
            this.semaphore = semaphore;
        }

        public boolean tryAcquire(int perms, long time, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(perms, time, unit);
        }

        public void release(int perms) {
            this.semaphore.release(perms);
        }
    }
}

