/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.ISemaphore;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.named.hazelcast.HazelcastSemaphoreProvider;
import org.eclipse.aether.named.support.AdaptedSemaphoreNamedLock;
import org.eclipse.aether.named.support.NamedLockFactorySupport;

public class HazelcastSemaphoreNamedLockFactory
extends NamedLockFactorySupport {
    protected final HazelcastInstance hazelcastInstance;
    protected final boolean manageHazelcast;
    private final HazelcastSemaphoreProvider hazelcastSemaphoreProvider;
    private final ConcurrentMap<String, ISemaphore> semaphores;

    public HazelcastSemaphoreNamedLockFactory(HazelcastInstance hazelcastInstance, boolean manageHazelcast, HazelcastSemaphoreProvider hazelcastSemaphoreProvider) {
        this.hazelcastInstance = Objects.requireNonNull(hazelcastInstance);
        this.manageHazelcast = manageHazelcast;
        this.hazelcastSemaphoreProvider = Objects.requireNonNull(hazelcastSemaphoreProvider);
        this.semaphores = new ConcurrentHashMap<String, ISemaphore>();
    }

    protected AdaptedSemaphoreNamedLock createLock(String name) {
        ISemaphore semaphore = this.semaphores.computeIfAbsent(name, k -> this.hazelcastSemaphoreProvider.acquireSemaphore(this.hazelcastInstance, name));
        return new AdaptedSemaphoreNamedLock(name, (NamedLockFactorySupport)this, (AdaptedSemaphoreNamedLock.AdaptedSemaphore)new HazelcastSemaphore(semaphore));
    }

    protected void destroyLock(String name) {
        this.hazelcastSemaphoreProvider.releaseSemaphore(this.hazelcastInstance, name, (ISemaphore)this.semaphores.remove(name));
    }

    public void shutdown() {
        if (this.manageHazelcast) {
            this.hazelcastInstance.shutdown();
        }
    }

    private static final class HazelcastSemaphore
    implements AdaptedSemaphoreNamedLock.AdaptedSemaphore {
        private final ISemaphore semaphore;

        private HazelcastSemaphore(ISemaphore semaphore) {
            this.semaphore = semaphore;
        }

        public boolean tryAcquire(int perms, long time, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(perms, time, unit);
        }

        public void release(int perms) {
            this.semaphore.release(perms);
        }
    }
}

