/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.ISemaphore;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.eclipse.aether.named.support.AdaptedSemaphoreNamedLock;
import org.eclipse.aether.named.support.NamedLockFactorySupport;

public class HazelcastSemaphoreNamedLockFactory
extends NamedLockFactorySupport {
    protected static final String NAME_PREFIX = "maven:resolver:";
    private final HazelcastInstance hazelcastInstance;
    private final BiFunction<HazelcastInstance, String, ISemaphore> semaphoreFunction;
    private final boolean destroySemaphore;
    private final boolean manageHazelcast;
    private final ConcurrentMap<String, ISemaphore> semaphores;

    public HazelcastSemaphoreNamedLockFactory(HazelcastInstance hazelcastInstance, BiFunction<HazelcastInstance, String, ISemaphore> semaphoreFunction, boolean destroySemaphore, boolean manageHazelcast) {
        this.hazelcastInstance = hazelcastInstance;
        this.semaphoreFunction = semaphoreFunction;
        this.destroySemaphore = destroySemaphore;
        this.manageHazelcast = manageHazelcast;
        this.semaphores = new ConcurrentHashMap<String, ISemaphore>();
    }

    protected AdaptedSemaphoreNamedLock createLock(String name) {
        ISemaphore semaphore = this.semaphores.computeIfAbsent(name, k -> {
            ISemaphore result = this.semaphoreFunction.apply(this.hazelcastInstance, (String)k);
            result.init(Integer.MAX_VALUE);
            return result;
        });
        return new AdaptedSemaphoreNamedLock(name, (NamedLockFactorySupport)this, (AdaptedSemaphoreNamedLock.AdaptedSemaphore)new HazelcastSemaphore(semaphore));
    }

    public void shutdown() {
        if (this.manageHazelcast) {
            this.hazelcastInstance.shutdown();
        }
    }

    protected void destroyLock(String name) {
        ISemaphore semaphore = (ISemaphore)this.semaphores.remove(name);
        if (this.destroySemaphore) {
            if (semaphore == null) {
                throw new IllegalStateException("Semaphore expected but does not exist: " + name);
            }
            semaphore.destroy();
        }
    }

    private static final class HazelcastSemaphore
    implements AdaptedSemaphoreNamedLock.AdaptedSemaphore {
        private final ISemaphore semaphore;

        private HazelcastSemaphore(ISemaphore semaphore) {
            this.semaphore = semaphore;
        }

        public boolean tryAcquire(int perms, long time, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(perms, time, unit);
        }

        public void release(int perms) {
            this.semaphore.release(perms);
        }
    }
}

