/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultLocalRepositoryProvider
implements LocalRepositoryProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLocalRepositoryProvider.class);
    private final Map<String, LocalRepositoryManagerFactory> localRepositoryManagerFactories;

    @Inject
    public DefaultLocalRepositoryProvider(Map<String, LocalRepositoryManagerFactory> localRepositoryManagerFactories) {
        this.localRepositoryManagerFactories = Collections.unmodifiableMap(localRepositoryManagerFactories);
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        PrioritizedComponents<LocalRepositoryManagerFactory> factories = PrioritizedComponents.reuseOrCreate(session, this.localRepositoryManagerFactories, LocalRepositoryManagerFactory::getPriority);
        ArrayList<NoLocalRepositoryManagerException> errors = new ArrayList<NoLocalRepositoryManagerException>();
        for (PrioritizedComponent<LocalRepositoryManagerFactory> prioritizedComponent : factories.getEnabled()) {
            try {
                LocalRepositoryManager manager = prioritizedComponent.getComponent().newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using manager ").append(manager.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, manager);
                    buffer.append(" with priority ").append(prioritizedComponent.getPriority());
                    buffer.append(" for ").append(repository.getBasePath());
                    LOGGER.debug(buffer.toString());
                }
                return manager;
            }
            catch (NoLocalRepositoryManagerException e) {
                errors.add(e);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            for (Exception exception : errors) {
                LOGGER.debug("Could not obtain local repository manager for {}", (Object)repository, (Object)exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No local repository managers registered");
        } else {
            buffer.append("Cannot access ").append(repository.getBasePath());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available factories ");
            factories.list(buffer);
        }
        throw new NoLocalRepositoryManagerException(repository, buffer.toString(), errors.size() == 1 ? (Throwable)errors.get(0) : null);
    }
}

