/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.spi.locking.LockingInhibitor;
import org.eclipse.aether.spi.locking.LockingInhibitorFactory;

@Singleton
@Named(value="prefixes")
public class PrefixesLockingInhibitorFactory
implements LockingInhibitorFactory,
LockingInhibitor {
    public static final String NAME = "prefixes";
    private static final Predicate<Metadata> PREFIX_PREDICATE = m -> "".equals(m.getGroupId()) && "".equals(m.getArtifactId()) && "".equals(m.getVersion()) && ".meta/prefixes.txt".equals(m.getType());

    public Optional<LockingInhibitor> newInstance(RepositorySystemSession session) {
        return Optional.of(this);
    }

    public boolean preventMetadataLocking(Metadata metadata) {
        return PREFIX_PREDICATE.test(metadata);
    }
}

