/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryFilterManager;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.UpdateCheck;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.SafeTransferListener;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.io.PathProcessor;
import org.eclipse.aether.spi.resolution.ArtifactResolverPostProcessor;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.aether.transfer.ArtifactFilteredOutException;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultArtifactResolver
implements ArtifactResolver {
    public static final String CONFIG_PROPS_PREFIX = "aether.artifactResolver.";
    public static final String CONFIG_PROP_SNAPSHOT_NORMALIZATION = "aether.artifactResolver.snapshotNormalization";
    public static final boolean DEFAULT_SNAPSHOT_NORMALIZATION = true;
    public static final String CONFIG_PROP_SIMPLE_LRM_INTEROP = "aether.artifactResolver.simpleLrmInterop";
    public static final boolean DEFAULT_SIMPLE_LRM_INTEROP = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArtifactResolver.class);
    private final PathProcessor pathProcessor;
    private final RepositoryEventDispatcher repositoryEventDispatcher;
    private final VersionResolver versionResolver;
    private final UpdateCheckManager updateCheckManager;
    private final RepositoryConnectorProvider repositoryConnectorProvider;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final SyncContextFactory syncContextFactory;
    private final OfflineController offlineController;
    private final Map<String, ArtifactResolverPostProcessor> artifactResolverPostProcessors;
    private final RemoteRepositoryFilterManager remoteRepositoryFilterManager;

    @Inject
    public DefaultArtifactResolver(PathProcessor pathProcessor, RepositoryEventDispatcher repositoryEventDispatcher, VersionResolver versionResolver, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController, Map<String, ArtifactResolverPostProcessor> artifactResolverPostProcessors, RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        this.pathProcessor = Objects.requireNonNull(pathProcessor, "path processor cannot be null");
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        this.versionResolver = Objects.requireNonNull(versionResolver, "version resolver cannot be null");
        this.updateCheckManager = Objects.requireNonNull(updateCheckManager, "update check manager cannot be null");
        this.repositoryConnectorProvider = Objects.requireNonNull(repositoryConnectorProvider, "repository connector provider cannot be null");
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        this.offlineController = Objects.requireNonNull(offlineController, "offline controller cannot be null");
        this.artifactResolverPostProcessors = Objects.requireNonNull(artifactResolverPostProcessors, "artifact resolver post-processors cannot be null");
        this.remoteRepositoryFilterManager = Objects.requireNonNull(remoteRepositoryFilterManager, "remote repository filter manager cannot be null");
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        return this.resolveArtifacts(session, Collections.singleton(request)).get(0);
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(requests, "requests cannot be null");
        try (SyncContext shared = this.syncContextFactory.newInstance(session, true);){
            List<ArtifactResult> list;
            block13: {
                SyncContext exclusive = this.syncContextFactory.newInstance(session, false);
                try {
                    ArrayList<Artifact> artifacts = new ArrayList<Artifact>(requests.size());
                    for (ArtifactRequest artifactRequest : requests) {
                        if (session.getSystemScopeHandler().getSystemPath(artifactRequest.getArtifact()) != null) continue;
                        artifacts.add(artifactRequest.getArtifact());
                    }
                    list = this.resolve(shared, exclusive, artifacts, session, requests);
                    if (exclusive == null) break block13;
                }
                catch (Throwable throwable) {
                    if (exclusive != null) {
                        try {
                            exclusive.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                exclusive.close();
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ArtifactResult> resolve(SyncContext shared, SyncContext exclusive, Collection<Artifact> subjects, RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        try (SyncContext current = shared;){
            ArrayList<ResolutionGroup> groups;
            ArrayList<ArtifactResult> results;
            boolean failures;
            while (true) {
                current.acquire(subjects, null);
                failures = false;
                results = new ArrayList<ArtifactResult>(requests.size());
                boolean simpleLrmInterop = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_SIMPLE_LRM_INTEROP});
                LocalRepositoryManager lrm = session.getLocalRepositoryManager();
                WorkspaceReader workspace = session.getWorkspaceReader();
                groups = new ArrayList<ResolutionGroup>();
                RemoteRepositoryFilter filter = this.remoteRepositoryFilterManager.getRemoteRepositoryFilter(session);
                for (ArtifactRequest artifactRequest : requests) {
                    boolean found;
                    Path path;
                    VersionResult versionResult;
                    String localPath;
                    RequestTrace trace = RequestTrace.newChild((RequestTrace)artifactRequest.getTrace(), (Object)artifactRequest);
                    ArtifactResult result = new ArtifactResult(artifactRequest);
                    results.add(result);
                    Artifact artifact = artifactRequest.getArtifact();
                    if (current == shared) {
                        this.artifactResolving(session, trace, artifact);
                    }
                    if ((localPath = session.getSystemScopeHandler().getSystemPath(artifact)) != null) {
                        Path path2 = Paths.get(localPath, new String[0]);
                        if (!Files.isRegularFile(path2, new LinkOption[0])) {
                            failures = true;
                            result.addException(ArtifactResult.NO_REPOSITORY, (Exception)new ArtifactNotFoundException(artifact, localPath));
                            continue;
                        }
                        artifact = artifact.setPath(path2);
                        result.setArtifact(artifact);
                        this.artifactResolved(session, trace, artifact, null, result.getExceptions());
                        continue;
                    }
                    List remoteRepositories = artifactRequest.getRepositories();
                    List<Object> filteredRemoteRepositories = new ArrayList(remoteRepositories);
                    if (filter != null) {
                        for (RemoteRepository repository : remoteRepositories) {
                            RemoteRepositoryFilter.Result filterResult = filter.acceptArtifact(repository, artifact);
                            if (filterResult.isAccepted()) continue;
                            result.addException((ArtifactRepository)repository, (Exception)new ArtifactFilteredOutException(artifact, repository, filterResult.reasoning()));
                            filteredRemoteRepositories.remove(repository);
                        }
                    }
                    try {
                        VersionRequest versionRequest = new VersionRequest(artifact, filteredRemoteRepositories, artifactRequest.getRequestContext());
                        versionRequest.setTrace(trace);
                        versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                    }
                    catch (VersionResolutionException e) {
                        if (filteredRemoteRepositories.isEmpty()) {
                            result.addException((ArtifactRepository)lrm.getRepository(), (Exception)((Object)e));
                            continue;
                        }
                        filteredRemoteRepositories.forEach(r -> result.addException((ArtifactRepository)r, (Exception)((Object)e)));
                        continue;
                    }
                    artifact = artifact.setVersion(versionResult.getVersion());
                    if (versionResult.getRepository() != null) {
                        filteredRemoteRepositories = versionResult.getRepository() instanceof RemoteRepository ? Collections.singletonList((RemoteRepository)versionResult.getRepository()) : Collections.emptyList();
                    }
                    if (workspace != null && (path = workspace.findArtifactPath(artifact)) != null) {
                        artifact = artifact.setPath(path);
                        result.setArtifact(artifact);
                        result.setRepository((ArtifactRepository)workspace.getRepository());
                        this.artifactResolved(session, trace, artifact, result.getRepository(), null);
                        continue;
                    }
                    LocalArtifactResult local = lrm.find(session, new LocalArtifactRequest(artifact, filteredRemoteRepositories, artifactRequest.getRequestContext()));
                    result.setLocalArtifactResult(local);
                    boolean bl = found = filter != null && local.isAvailable() || this.isLocallyInstalled(local, versionResult);
                    if (found) {
                        if (local.getRepository() != null) {
                            result.setRepository((ArtifactRepository)local.getRepository());
                        } else {
                            result.setRepository((ArtifactRepository)lrm.getRepository());
                        }
                        try {
                            artifact = artifact.setPath(this.getPath(session, artifact, local.getPath()));
                            result.setArtifact(artifact);
                            this.artifactResolved(session, trace, artifact, result.getRepository(), null);
                        }
                        catch (ArtifactTransferException e) {
                            result.addException((ArtifactRepository)lrm.getRepository(), (Exception)((Object)e));
                        }
                        if (filter != null || !simpleLrmInterop || local.isAvailable()) continue;
                        lrm.add(session, new LocalArtifactRegistration(artifact));
                        continue;
                    }
                    if (local.getPath() != null) {
                        LOGGER.info("Artifact {} is present in the local repository, but cached from a remote repository ID that is unavailable in current build context, verifying that is downloadable from {}", (Object)artifact, (Object)remoteRepositories);
                    }
                    LOGGER.debug("Resolving artifact {} from {}", (Object)artifact, (Object)remoteRepositories);
                    AtomicBoolean resolved = new AtomicBoolean(false);
                    Iterator<Object> groupIt = groups.iterator();
                    for (RemoteRepository remoteRepository : filteredRemoteRepositories) {
                        if (!remoteRepository.getPolicy(artifact.isSnapshot()).isEnabled()) continue;
                        try {
                            Utils.checkOffline(session, this.offlineController, remoteRepository);
                        }
                        catch (RepositoryOfflineException e) {
                            ArtifactNotFoundException exception = new ArtifactNotFoundException(artifact, remoteRepository, "Cannot access " + remoteRepository.getId() + " (" + remoteRepository.getUrl() + ") in offline mode and the artifact " + artifact + " has not been downloaded from it before.", (Throwable)e);
                            result.addException((ArtifactRepository)remoteRepository, (Exception)exception);
                            continue;
                        }
                        ResolutionGroup group = null;
                        while (groupIt.hasNext()) {
                            ResolutionGroup t = (ResolutionGroup)groupIt.next();
                            if (!t.matches(remoteRepository)) continue;
                            group = t;
                            break;
                        }
                        if (group == null) {
                            group = new ResolutionGroup(remoteRepository);
                            groups.add(group);
                            groupIt = Collections.emptyIterator();
                        }
                        group.items.add(new ResolutionItem(trace, artifact, resolved, result, local, remoteRepository));
                    }
                }
                if (groups.isEmpty() || current != shared) break;
                current.close();
                current = exclusive;
            }
            for (ResolutionGroup resolutionGroup : groups) {
                this.performDownloads(session, resolutionGroup);
            }
            for (ArtifactResolverPostProcessor artifactResolverPostProcessor : this.artifactResolverPostProcessors.values()) {
                artifactResolverPostProcessor.postProcess(session, results);
            }
            for (ArtifactResult artifactResult : results) {
                ArtifactRequest request = artifactResult.getRequest();
                Artifact artifact = artifactResult.getArtifact();
                if (artifact != null && artifact.getPath() != null) continue;
                failures = true;
                if (artifactResult.getExceptions().isEmpty()) {
                    ArtifactNotFoundException exception = new ArtifactNotFoundException(request.getArtifact(), (RemoteRepository)null);
                    artifactResult.addException(artifactResult.getRepository(), (Exception)exception);
                }
                RequestTrace trace = RequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
                this.artifactResolved(session, trace, request.getArtifact(), null, artifactResult.getExceptions());
            }
            if (failures) {
                throw new ArtifactResolutionException(results);
            }
            ArrayList<ArtifactResult> arrayList = results;
            return arrayList;
        }
    }

    private boolean isLocallyInstalled(LocalArtifactResult lar, VersionResult vr) {
        if (lar.isAvailable()) {
            return true;
        }
        if (lar.getPath() != null) {
            if (vr.getRepository() instanceof LocalRepository) {
                return true;
            }
            return vr.getRepository() == null && lar.getRequest().getRepositories().isEmpty();
        }
        return false;
    }

    private Path getPath(RepositorySystemSession session, Artifact artifact, Path path) throws ArtifactTransferException {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion()) && ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{CONFIG_PROP_SNAPSHOT_NORMALIZATION})) {
            String name = path.getFileName().toString().replace(artifact.getVersion(), artifact.getBaseVersion());
            Path dst = path.getParent().resolve(name);
            try {
                boolean copy;
                long pathLastModified = this.pathProcessor.lastModified(path, 0L);
                boolean bl = copy = this.pathProcessor.size(dst, 0L) != this.pathProcessor.size(path, 0L) || this.pathProcessor.lastModified(dst, 0L) != pathLastModified;
                if (copy) {
                    this.pathProcessor.copy(path, dst);
                    Files.setLastModifiedTime(dst, FileTime.fromMillis(pathLastModified));
                }
            }
            catch (IOException e) {
                throw new ArtifactTransferException(artifact, null, (Throwable)e);
            }
            path = dst;
        }
        return path;
    }

    private void performDownloads(RepositorySystemSession session, ResolutionGroup group) {
        List<ArtifactDownload> downloads = this.gatherDownloads(session, group);
        if (downloads.isEmpty()) {
            return;
        }
        for (ArtifactDownload download : downloads) {
            this.artifactDownloading(session, download.getTrace(), download.getArtifact(), group.repository);
        }
        try (RepositoryConnector connector = this.repositoryConnectorProvider.newRepositoryConnector(session, group.repository);){
            connector.get(downloads, null);
        }
        catch (NoRepositoryConnectorException e) {
            for (ArtifactDownload download : downloads) {
                download.setException(new ArtifactTransferException(download.getArtifact(), group.repository, (Throwable)e));
            }
        }
        this.evaluateDownloads(session, group);
    }

    private List<ArtifactDownload> gatherDownloads(RepositorySystemSession session, ResolutionGroup group) {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        ArrayList<ArtifactDownload> downloads = new ArrayList<ArtifactDownload>();
        for (ResolutionItem item : group.items) {
            Artifact artifact = item.artifact;
            if (item.resolved.get()) continue;
            ArtifactDownload download = new ArtifactDownload();
            download.setArtifact(artifact);
            download.setRequestContext(item.request.getRequestContext());
            download.setListener(SafeTransferListener.wrap(session));
            download.setTrace(item.trace);
            if (item.local.getPath() != null) {
                download.setPath(item.local.getPath());
                download.setExistenceCheck(true);
            } else {
                String path = lrm.getPathForRemoteArtifact(artifact, group.repository, item.request.getRequestContext());
                download.setPath(lrm.getRepository().getBasePath().resolve(path));
            }
            boolean snapshot = artifact.isSnapshot();
            RepositoryPolicy policy = this.remoteRepositoryManager.getPolicy(session, group.repository, !snapshot, snapshot);
            int errorPolicy = Utils.getPolicy(session, artifact, group.repository);
            if ((errorPolicy & 3) != 0) {
                UpdateCheck<Artifact, ArtifactTransferException> check = new UpdateCheck<Artifact, ArtifactTransferException>();
                check.setItem(artifact);
                check.setPath(download.getPath());
                check.setFileValid(false);
                check.setRepository(group.repository);
                check.setArtifactPolicy(policy.getArtifactUpdatePolicy());
                check.setMetadataPolicy(policy.getMetadataUpdatePolicy());
                item.updateCheck = check;
                this.updateCheckManager.checkArtifact(session, check);
                if (!check.isRequired()) {
                    item.result.addException((ArtifactRepository)group.repository, (Exception)((Object)check.getException()));
                    continue;
                }
            }
            download.setChecksumPolicy(policy.getChecksumPolicy());
            download.setRepositories(item.repository.getMirroredRepositories());
            downloads.add(download);
            item.download = download;
        }
        return downloads;
    }

    private void evaluateDownloads(RepositorySystemSession session, ResolutionGroup group) {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        for (ResolutionItem item : group.items) {
            ArtifactDownload download = item.download;
            if (download == null) continue;
            Artifact artifact = download.getArtifact();
            if (download.getException() == null) {
                item.resolved.set(true);
                item.result.setRepository((ArtifactRepository)group.repository);
                try {
                    artifact = artifact.setPath(this.getPath(session, artifact, download.getPath()));
                    item.result.setArtifact(artifact);
                    lrm.add(session, new LocalArtifactRegistration(artifact, group.repository, download.getSupportedContexts()));
                }
                catch (ArtifactTransferException e) {
                    download.setException(e);
                    item.result.addException((ArtifactRepository)group.repository, (Exception)((Object)e));
                }
            } else {
                item.result.addException((ArtifactRepository)group.repository, (Exception)((Object)download.getException()));
            }
            if (item.updateCheck != null) {
                item.updateCheck.setException(download.getException());
                this.updateCheckManager.touchArtifact(session, item.updateCheck);
            }
            this.artifactDownloaded(session, download.getTrace(), artifact, group.repository, (Exception)((Object)download.getException()));
            if (download.getException() != null) continue;
            this.artifactResolved(session, download.getTrace(), artifact, (ArtifactRepository)group.repository, null);
        }
    }

    private void artifactResolving(RepositorySystemSession session, RequestTrace trace, Artifact artifact) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_RESOLVING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactResolved(RepositorySystemSession session, RequestTrace trace, Artifact artifact, ArtifactRepository repository, Collection<Exception> exceptions) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_RESOLVED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(repository);
        event.setExceptions((List)(exceptions != null ? new ArrayList<Exception>(exceptions) : null));
        if (artifact != null) {
            event.setPath(artifact.getPath());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloading(RepositorySystemSession session, RequestTrace trace, Artifact artifact, RemoteRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DOWNLOADING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository((ArtifactRepository)repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloaded(RepositorySystemSession session, RequestTrace trace, Artifact artifact, RemoteRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DOWNLOADED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository((ArtifactRepository)repository);
        event.setException(exception);
        if (artifact != null) {
            event.setPath(artifact.getPath());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    static class ResolutionGroup {
        final RemoteRepository repository;
        final List<ResolutionItem> items = new ArrayList<ResolutionItem>();

        ResolutionGroup(RemoteRepository repository) {
            this.repository = repository;
        }

        boolean matches(RemoteRepository repo) {
            return this.repository.getUrl().equals(repo.getUrl()) && this.repository.getContentType().equals(repo.getContentType()) && this.repository.isRepositoryManager() == repo.isRepositoryManager();
        }
    }

    static class ResolutionItem {
        final RequestTrace trace;
        final ArtifactRequest request;
        final ArtifactResult result;
        final LocalArtifactResult local;
        final RemoteRepository repository;
        final Artifact artifact;
        final AtomicBoolean resolved;
        ArtifactDownload download;
        UpdateCheck<Artifact, ArtifactTransferException> updateCheck;

        ResolutionItem(RequestTrace trace, Artifact artifact, AtomicBoolean resolved, ArtifactResult result, LocalArtifactResult local, RemoteRepository repository) {
            this.trace = trace;
            this.artifact = artifact;
            this.resolved = resolved;
            this.result = result;
            this.request = result.getRequest();
            this.local = local;
            this.repository = repository;
        }
    }
}

