/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.checksum;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.internal.impl.checksum.Md5ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha256ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha512ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;

@Singleton
@Named
public class DefaultChecksumAlgorithmFactorySelector
implements ChecksumAlgorithmFactorySelector {
    private final Map<String, ChecksumAlgorithmFactory> factories;

    @Deprecated
    public DefaultChecksumAlgorithmFactorySelector() {
        this.factories = new HashMap<String, ChecksumAlgorithmFactory>();
        this.factories.put("SHA-512", (ChecksumAlgorithmFactory)new Sha512ChecksumAlgorithmFactory());
        this.factories.put("SHA-256", (ChecksumAlgorithmFactory)new Sha256ChecksumAlgorithmFactory());
        this.factories.put("SHA-1", (ChecksumAlgorithmFactory)new Sha1ChecksumAlgorithmFactory());
        this.factories.put("MD5", (ChecksumAlgorithmFactory)new Md5ChecksumAlgorithmFactory());
    }

    @Inject
    public DefaultChecksumAlgorithmFactorySelector(Map<String, ChecksumAlgorithmFactory> factories) {
        this.factories = Objects.requireNonNull(factories);
    }

    public ChecksumAlgorithmFactory select(String algorithmName) {
        Objects.requireNonNull(algorithmName, "algorithmMame must not be null");
        ChecksumAlgorithmFactory factory = this.factories.get(algorithmName);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Unsupported checksum algorithm %s, supported ones are %s", algorithmName, this.getChecksumAlgorithmFactories().stream().map(ChecksumAlgorithmFactory::getName).collect(Collectors.toList())));
        }
        return factory;
    }

    public List<ChecksumAlgorithmFactory> selectList(Collection<String> algorithmNames) {
        return algorithmNames.stream().map(this::select).collect(Collectors.toList());
    }

    public List<ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
        return new ArrayList<ChecksumAlgorithmFactory>(this.factories.values());
    }
}

