/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapter;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactorySelector;
import org.eclipse.aether.internal.impl.synccontext.named.ParameterizedNamedLockFactorySelector;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;

@Singleton
@Named
public final class DefaultSyncContextFactory
implements SyncContextFactory,
Service {
    private NamedLockFactoryAdapter namedLockFactoryAdapter;

    @Inject
    public DefaultSyncContextFactory(RepositorySystemLifecycle repositorySystemLifecycle, NamedLockFactorySelector selector) {
        repositorySystemLifecycle.addOnSystemEndedHandler(this::shutDownAdapter);
        this.namedLockFactoryAdapter = new NamedLockFactoryAdapter(selector.getSelectedNameMapper(), selector.getSelectedNamedLockFactory());
    }

    @Deprecated
    public DefaultSyncContextFactory() {
    }

    public void initService(ServiceLocator locator) {
        ((RepositorySystemLifecycle)locator.getService(RepositorySystemLifecycle.class)).addOnSystemEndedHandler(this::shutDownAdapter);
        ParameterizedNamedLockFactorySelector selector = new ParameterizedNamedLockFactorySelector();
        this.namedLockFactoryAdapter = new NamedLockFactoryAdapter(selector.getSelectedNameMapper(), selector.getSelectedNamedLockFactory());
    }

    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        Objects.requireNonNull(session, "session cannot be null");
        return this.namedLockFactoryAdapter.newInstance(session, shared);
    }

    private void shutDownAdapter() {
        if (this.namedLockFactoryAdapter != null) {
            this.namedLockFactoryAdapter.shutdown();
        }
    }
}

