/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether;

import java.io.Closeable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.SystemScopeHandler;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.transfer.TransferListener;

public interface RepositorySystemSession {
    public boolean isOffline();

    public boolean isIgnoreArtifactDescriptorRepositories();

    public ResolutionErrorPolicy getResolutionErrorPolicy();

    public ArtifactDescriptorPolicy getArtifactDescriptorPolicy();

    public String getChecksumPolicy();

    public String getUpdatePolicy();

    public String getArtifactUpdatePolicy();

    public String getMetadataUpdatePolicy();

    public LocalRepository getLocalRepository();

    public LocalRepositoryManager getLocalRepositoryManager();

    public WorkspaceReader getWorkspaceReader();

    public RepositoryListener getRepositoryListener();

    public TransferListener getTransferListener();

    public Map<String, String> getSystemProperties();

    public Map<String, String> getUserProperties();

    public Map<String, Object> getConfigProperties();

    public MirrorSelector getMirrorSelector();

    public ProxySelector getProxySelector();

    public AuthenticationSelector getAuthenticationSelector();

    public ArtifactTypeRegistry getArtifactTypeRegistry();

    public DependencyTraverser getDependencyTraverser();

    public DependencyManager getDependencyManager();

    public DependencySelector getDependencySelector();

    public VersionFilter getVersionFilter();

    public DependencyGraphTransformer getDependencyGraphTransformer();

    public SessionData getData();

    public RepositoryCache getCache();

    public SystemScopeHandler getSystemScopeHandler();

    public boolean addOnSessionEndedHandler(Runnable var1);

    public static interface SessionBuilder {
        public SessionBuilder setOffline(boolean var1);

        public SessionBuilder setIgnoreArtifactDescriptorRepositories(boolean var1);

        public SessionBuilder setResolutionErrorPolicy(ResolutionErrorPolicy var1);

        public SessionBuilder setArtifactDescriptorPolicy(ArtifactDescriptorPolicy var1);

        public SessionBuilder setChecksumPolicy(String var1);

        public SessionBuilder setUpdatePolicy(String var1);

        public SessionBuilder setArtifactUpdatePolicy(String var1);

        public SessionBuilder setMetadataUpdatePolicy(String var1);

        public SessionBuilder setLocalRepositoryManager(LocalRepositoryManager var1);

        public SessionBuilder setWorkspaceReader(WorkspaceReader var1);

        public SessionBuilder setRepositoryListener(RepositoryListener var1);

        public SessionBuilder setTransferListener(TransferListener var1);

        public SessionBuilder setSystemProperties(Map<?, ?> var1);

        public SessionBuilder setSystemProperty(String var1, String var2);

        public SessionBuilder setUserProperties(Map<?, ?> var1);

        public SessionBuilder setUserProperty(String var1, String var2);

        public SessionBuilder setConfigProperties(Map<?, ?> var1);

        public SessionBuilder setConfigProperty(String var1, Object var2);

        public SessionBuilder setMirrorSelector(MirrorSelector var1);

        public SessionBuilder setProxySelector(ProxySelector var1);

        public SessionBuilder setAuthenticationSelector(AuthenticationSelector var1);

        public SessionBuilder setArtifactTypeRegistry(ArtifactTypeRegistry var1);

        public SessionBuilder setDependencyTraverser(DependencyTraverser var1);

        public SessionBuilder setDependencyManager(DependencyManager var1);

        public SessionBuilder setDependencySelector(DependencySelector var1);

        public SessionBuilder setVersionFilter(VersionFilter var1);

        public SessionBuilder setDependencyGraphTransformer(DependencyGraphTransformer var1);

        public SessionBuilder setData(SessionData var1);

        public SessionBuilder setCache(RepositoryCache var1);

        public SessionBuilder setSystemScopeHandler(SystemScopeHandler var1);

        public SessionBuilder addOnSessionEndedHandler(Runnable var1);

        public SessionBuilder setSessionDataSupplier(Supplier<SessionData> var1);

        public SessionBuilder setRepositoryCacheSupplier(Supplier<RepositoryCache> var1);

        public SessionBuilder withLocalRepositoryBaseDirectories(Path ... var1);

        public SessionBuilder withLocalRepositoryBaseDirectories(Collection<Path> var1);

        public SessionBuilder withLocalRepositories(LocalRepository ... var1);

        public SessionBuilder withLocalRepositories(Collection<LocalRepository> var1);

        public SessionBuilder withRepositoryListener(RepositoryListener ... var1);

        public SessionBuilder withRepositoryListener(Collection<RepositoryListener> var1);

        public SessionBuilder withTransferListener(TransferListener ... var1);

        public SessionBuilder withTransferListener(Collection<TransferListener> var1);

        public SessionBuilder withRepositorySystemSession(RepositorySystemSession var1);

        public CloseableSession build();
    }

    public static interface CloseableSession
    extends RepositorySystemSession,
    Closeable {
        public String sessionId();

        @Override
        public void close();
    }
}

