/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.war.util;

import java.io.File;
import java.io.IOException;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class ClassesPackager {
    public void packageClasses(File classesDirectory, File targetFile, JarArchiver jarArchiver, MavenSession session, MavenProject project, MavenArchiveConfiguration archiveConfiguration, String outputTimestamp) throws MojoExecutionException {
        try {
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(jarArchiver);
            archiver.setOutputFile(targetFile);
            archiver.setCreatedBy("Maven WAR Plugin", "org.apache.maven.plugins", "maven-war-plugin");
            archiver.configureReproducibleBuild(outputTimestamp);
            archiver.getArchiver().addDirectory(classesDirectory);
            archiver.createArchive(session, project, archiveConfiguration);
        }
        catch (IOException | DependencyResolutionRequiredException | ArchiverException | ManifestException e) {
            throw new MojoExecutionException("Could not create classes archive", (Exception)e);
        }
    }

    public File getClassesDirectory(File webappDirectory) {
        return new File(webappDirectory, "WEB-INF/classes/");
    }
}

