/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.source;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.source.SourceBundler;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class JarSourceMojo
extends AbstractMojo {
    private static final List BANNED_PACKAGINGS;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private String packaging;
    private String finalName;
    private boolean attach = true;
    private List compileSourceRoots;
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        if (!this.attach) {
            this.getLog().info((CharSequence)"NOT adding java-sources to attached artifacts list.");
            return;
        }
        if (BANNED_PACKAGINGS.contains(this.packaging)) {
            this.getLog().info((CharSequence)("NOT adding java-sources to attached artifacts for packaging: '" + this.packaging + "'."));
            return;
        }
        JarArchiver archiver = new JarArchiver();
        SourceBundler sourceBundler = new SourceBundler();
        File outputFile = new File(this.outputDirectory, this.finalName + "-sources.jar");
        File[] sourceDirectories = new File[this.compileSourceRoots.size()];
        int count = 0;
        Iterator i = this.compileSourceRoots.iterator();
        while (i.hasNext()) {
            sourceDirectories[count] = new File((String)i.next());
            ++count;
        }
        try {
            sourceBundler.makeSourceBundle(outputFile, sourceDirectories, (Archiver)archiver);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error building source JAR", e);
        }
        this.projectHelper.attachArtifact(this.project, "java-source", "sources", outputFile);
    }

    static {
        ArrayList<String> banned = new ArrayList<String>();
        banned.add("pom");
        BANNED_PACKAGINGS = banned;
    }
}

