/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources.remote;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.resources.remote.RemoteResourcesBundle;
import org.apache.maven.plugin.resources.remote.io.xpp3.RemoteResourcesBundleXpp3Writer;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="bundle", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class BundleRemoteResourcesMojo
extends AbstractMojo {
    public static final String RESOURCES_MANIFEST = "META-INF/maven/remote-resources.xml";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.txt", "**/*.vm"};
    @Parameter(defaultValue="${basedir}/src/main/resources")
    private File resourcesDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding;
    @Parameter(property="bundle.requiredProjectProperties")
    private List<String> requiredProjectProperties;

    public void execute() throws MojoExecutionException {
        String[] includedFiles;
        if (!this.resourcesDirectory.exists()) {
            this.getLog().info((CharSequence)("skip non existing resourceDirectory " + this.resourcesDirectory.getAbsolutePath()));
            return;
        }
        if (this.sourceEncoding == null || this.sourceEncoding.isEmpty()) {
            this.getLog().warn((CharSequence)("sourceEncoding has not been set; using platform encoding " + Charset.defaultCharset() + "; i.e. build is platform dependent!"));
            this.sourceEncoding = Charset.defaultCharset().name();
        }
        RemoteResourcesBundle remoteResourcesBundle = new RemoteResourcesBundle();
        remoteResourcesBundle.setSourceEncoding(this.sourceEncoding);
        remoteResourcesBundle.setRequiredProjectProperties(this.requiredProjectProperties);
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setFilenameComparator(Comparator.naturalOrder());
        scanner.setBasedir(this.resourcesDirectory);
        if (this.includes != null && this.includes.length != 0) {
            scanner.setIncludes(this.includes);
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (this.excludes != null && this.excludes.length != 0) {
            scanner.setExcludes(this.excludes);
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        for (String resource : includedFiles = scanner.getIncludedFiles()) {
            remoteResourcesBundle.addRemoteResource(StringUtils.replace((String)resource, (char)'\\', (char)'/'));
        }
        int n = remoteResourcesBundle.getRemoteResources().size();
        this.getLog().info((CharSequence)("Writing META-INF/maven/remote-resources.xml descriptor with " + n + " entr" + (n > 1 ? "ies" : "y")));
        RemoteResourcesBundleXpp3Writer w = new RemoteResourcesBundleXpp3Writer();
        File f = new File(this.outputDirectory, RESOURCES_MANIFEST);
        FileUtils.mkdir((String)f.getParentFile().getAbsolutePath());
        try (FileWriter writer = new FileWriter(f);){
            w.write(writer, remoteResourcesBundle);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating remote resources manifest.", (Exception)e);
        }
    }
}

