/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseManager;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.DefaultReleaseEnvironment;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReleaseMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", readonly=true, required=true)
    private File basedir;
    @Component
    private Settings settings;
    @Component
    protected MavenProject project;
    @Component
    protected ReleaseManager releaseManager;
    @Parameter(alias="prepareVerifyArgs", property="arguments")
    private String arguments;
    @Parameter(property="pomFileName")
    private String pomFileName;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${maven.home}")
    private File mavenHome;
    @Parameter(defaultValue="${java.home}")
    private File javaHome;
    @Parameter(defaultValue="${maven.repo.local}")
    private File localRepoDirectory;
    @Parameter(defaultValue="invoker", property="mavenExecutorId")
    private String mavenExecutorId;
    @Component
    protected MavenSession session;

    protected ReleaseEnvironment getReleaseEnvironment() {
        return new DefaultReleaseEnvironment().setSettings(this.settings).setJavaHome(this.javaHome).setMavenHome(this.mavenHome).setLocalRepositoryDirectory(this.localRepoDirectory).setMavenExecutorId(this.mavenExecutorId);
    }

    protected ReleaseDescriptor createReleaseDescriptor() {
        ReleaseDescriptor descriptor = new ReleaseDescriptor();
        descriptor.setInteractive(this.settings.isInteractiveMode());
        descriptor.setWorkingDirectory(this.basedir.getAbsolutePath());
        descriptor.setPomFileName(this.pomFileName);
        List<String> profileIds = this.getActiveProfileIds();
        String additionalProfiles = this.getAdditionalProfiles();
        String args = this.arguments;
        if (!profileIds.isEmpty() || StringUtils.isNotBlank((String)additionalProfiles)) {
            args = !StringUtils.isEmpty((String)args) ? args + " -P " : "-P ";
            Iterator<String> it = profileIds.iterator();
            while (it.hasNext()) {
                args = args + it.next();
                if (!it.hasNext()) continue;
                args = args + ",";
            }
            if (additionalProfiles != null) {
                if (!profileIds.isEmpty()) {
                    args = args + ",";
                }
                args = args + additionalProfiles;
            }
        }
        descriptor.setAdditionalArguments(args);
        return descriptor;
    }

    private List<String> getActiveProfileIds() {
        List profiles;
        try {
            Method getRequestMethod = this.session.getClass().getMethod("getRequest", new Class[0]);
            Object mavenExecutionRequest = getRequestMethod.invoke((Object)this.session, new Object[0]);
            Method getActiveProfilesMethod = mavenExecutionRequest.getClass().getMethod("getActiveProfiles", new Class[0]);
            profiles = (List)getActiveProfilesMethod.invoke(mavenExecutionRequest, new Object[0]);
        }
        catch (Exception e) {
            if (this.project.getActiveProfiles() == null || this.project.getActiveProfiles().isEmpty()) {
                profiles = Collections.emptyList();
            }
            profiles = new ArrayList<String>(this.project.getActiveProfiles().size());
            for (Object profile : this.project.getActiveProfiles()) {
                profiles.add(((Profile)profile).getId());
            }
        }
        return profiles;
    }

    protected String getAdditionalProfiles() {
        return null;
    }

    void setReleaseManager(ReleaseManager releaseManager) {
        this.releaseManager = releaseManager;
    }

    Settings getSettings() {
        return this.settings;
    }

    protected final File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected void addArgument(String argument) {
        this.arguments = this.arguments != null ? this.arguments + " " + argument : argument;
    }

    protected void mergeCommandLineConfig(ReleaseDescriptor config, ReleaseDescriptor sysPropertiesConfig) {
        if (sysPropertiesConfig.getReleaseVersions() != null) {
            config.getReleaseVersions().putAll(sysPropertiesConfig.getReleaseVersions());
        }
        if (sysPropertiesConfig.getDevelopmentVersions() != null) {
            config.getDevelopmentVersions().putAll(sysPropertiesConfig.getDevelopmentVersions());
        }
    }
}

