/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ServiceExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceExecutor.class);
    private final ToolchainManager toolchainManager;
    private final Provider<MavenSession> sessionProvider;

    protected ServiceExecutor(ToolchainManager toolchainManager, Provider<MavenSession> sessionProvider) {
        this.toolchainManager = toolchainManager;
        this.sessionProvider = sessionProvider;
    }

    protected final Toolchain getToolchain(Map<String, String> jdkToolchain) {
        List tcs;
        Toolchain tc = null;
        if (jdkToolchain != null && (tcs = this.toolchainManager.getToolchains((MavenSession)this.sessionProvider.get(), "jdk", jdkToolchain)) != null && !tcs.isEmpty()) {
            tc = (Toolchain)tcs.get(0);
        }
        if (tc == null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", (MavenSession)this.sessionProvider.get());
        }
        return tc;
    }

    protected String getJavaExecutable(Map<String, String> jdkToolchain) {
        Toolchain tc = this.getToolchain(jdkToolchain);
        if (tc != null) {
            LOG.info("Toolchain in maven-pmd-plugin: {}", (Object)tc);
            return tc.findTool("java");
        }
        return null;
    }
}

