/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugins.javadoc.JavadocModule;
import org.apache.maven.plugins.javadoc.JavadocUtil;
import org.apache.maven.plugins.javadoc.options.JavadocOptions;
import org.apache.maven.plugins.javadoc.options.io.xpp3.JavadocOptionsXpp3Reader;
import org.apache.maven.plugins.javadoc.resolver.JavadocBundle;
import org.apache.maven.plugins.javadoc.resolver.SourceResolverConfig;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.resolve.transform.ArtifactIncludeFilterTransformer;
import org.apache.maven.shared.artifact.filter.resolve.transform.EclipseAetherFilterTransformer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public final class ResourceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceResolver.class);
    @Inject
    private RepositorySystem repoSystem;
    @Inject
    private ArchiverManager archiverManager;
    public static final String SOURCES_CLASSIFIER = "sources";
    public static final String TEST_SOURCES_CLASSIFIER = "test-sources";
    private static final List<String> SOURCE_VALID_CLASSIFIERS = Arrays.asList("sources", "test-sources");
    private static final List<String> RESOURCE_VALID_CLASSIFIERS = Arrays.asList("javadoc-resources", "test-javadoc-resources");

    public List<JavadocBundle> resolveDependencyJavadocBundles(SourceResolverConfig config) throws IOException {
        ArrayList<JavadocBundle> bundles = new ArrayList<JavadocBundle>();
        HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
        if (config.reactorProjects() != null) {
            for (MavenProject p : config.reactorProjects()) {
                projectMap.put(ArtifactUtils.key((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion()), p);
            }
        }
        List artifacts = config.project().getTestArtifacts();
        ArrayList<Artifact> forResourceResolution = new ArrayList<Artifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            MavenProject p = (MavenProject)projectMap.get(ArtifactUtils.key((Artifact)artifact));
            if (p != null) {
                bundles.addAll(ResourceResolver.resolveBundleFromProject(config, p, artifact));
                continue;
            }
            forResourceResolution.add(artifact);
        }
        bundles.addAll(this.resolveBundlesFromArtifacts(config, forResourceResolution));
        return bundles;
    }

    public Collection<JavadocModule> resolveDependencySourcePaths(SourceResolverConfig config) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList<JavadocModule> mappedDirs = new ArrayList<JavadocModule>();
        HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
        if (config.reactorProjects() != null) {
            for (MavenProject p : config.reactorProjects()) {
                projectMap.put(ArtifactUtils.key((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion()), p);
            }
        }
        List artifacts = config.project().getTestArtifacts();
        for (Artifact artifact : artifacts) {
            String key = ArtifactUtils.key((Artifact)artifact);
            MavenProject p = (MavenProject)projectMap.get(key);
            if (p != null) {
                mappedDirs.add(new JavadocModule(key, artifact.getFile(), ResourceResolver.resolveFromProject(config, p, artifact)));
                continue;
            }
            JavadocModule m = this.resolveFromArtifact(config, artifact);
            if (m == null) continue;
            mappedDirs.add(m);
        }
        return mappedDirs;
    }

    private static List<JavadocBundle> resolveBundleFromProject(SourceResolverConfig config, MavenProject project, Artifact artifact) throws IOException {
        ArrayList<JavadocBundle> bundles = new ArrayList<JavadocBundle>();
        ArrayList<String> classifiers = new ArrayList<String>();
        if (config.includeCompileSources()) {
            classifiers.add("javadoc-resources");
        }
        if (config.includeTestSources()) {
            classifiers.add("test-javadoc-resources");
        }
        for (String classifier : classifiers) {
            File optionsFile = new File(project.getBuild().getDirectory(), "javadoc-bundle-options/javadoc-options-" + classifier + ".xml");
            if (!optionsFile.exists()) continue;
            try (FileInputStream stream = new FileInputStream(optionsFile);){
                JavadocOptions options = new JavadocOptionsXpp3Reader().read(stream);
                bundles.add(new JavadocBundle(options, new File(project.getBasedir(), options.getJavadocResourcesDirectory())));
            }
            catch (XmlPullParserException e) {
                IOException error = new IOException("Failed to read javadoc options from: " + optionsFile + "\nReason: " + e.getMessage(), e);
                throw error;
            }
        }
        return bundles;
    }

    private List<JavadocBundle> resolveBundlesFromArtifacts(SourceResolverConfig config, List<Artifact> artifacts) throws IOException {
        Collection<Object> dirs;
        block13: {
            ArrayList<org.eclipse.aether.artifact.Artifact> toResolve = new ArrayList<org.eclipse.aether.artifact.Artifact>(artifacts.size());
            for (Artifact artifact : artifacts) {
                if (config.filter() != null && !new ArtifactIncludeFilterTransformer().transform(config.filter()).include(artifact)) continue;
                if (config.includeCompileSources()) {
                    toResolve.add(this.createResourceArtifact(artifact, "javadoc-resources", config));
                }
                if (!config.includeTestSources()) continue;
                toResolve.add(this.createResourceArtifact(artifact, "test-javadoc-resources", config));
            }
            dirs = new ArrayList(toResolve.size());
            try {
                dirs = this.resolveAndUnpack(toResolve, config, RESOURCE_VALID_CLASSIFIERS, false);
            }
            catch (ArtifactResolutionException e) {
                if (!LOGGER.isDebugEnabled()) break block13;
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<JavadocBundle> result = new ArrayList<JavadocBundle>();
        for (Path path : dirs) {
            File dir = path.toFile();
            File resources = new File(dir, "resources");
            JavadocOptions options = null;
            File javadocOptions = new File(dir, "META-INF/maven/javadoc-options.xml");
            if (javadocOptions.exists()) {
                try (FileInputStream reader = new FileInputStream(javadocOptions);){
                    options = new JavadocOptionsXpp3Reader().read(reader);
                }
                catch (XmlPullParserException e) {
                    IOException error = new IOException("Failed to parse javadoc options: " + e.getMessage(), e);
                    throw error;
                }
            }
            result.add(new JavadocBundle(options, resources));
        }
        return result;
    }

    private JavadocModule resolveFromArtifact(SourceResolverConfig config, Artifact artifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList<org.eclipse.aether.artifact.Artifact> toResolve = new ArrayList<org.eclipse.aether.artifact.Artifact>(2);
        if (config.filter() != null && !new ArtifactIncludeFilterTransformer().transform(config.filter()).include(artifact)) {
            return null;
        }
        if (config.includeCompileSources()) {
            toResolve.add(this.createResourceArtifact(artifact, SOURCES_CLASSIFIER, config));
        }
        if (config.includeTestSources()) {
            toResolve.add(this.createResourceArtifact(artifact, TEST_SOURCES_CLASSIFIER, config));
        }
        Collection<Path> sourcePaths = this.resolveAndUnpack(toResolve, config, SOURCE_VALID_CLASSIFIERS, true);
        return new JavadocModule(ArtifactUtils.key((Artifact)artifact), artifact.getFile(), sourcePaths);
    }

    private org.eclipse.aether.artifact.Artifact createResourceArtifact(Artifact artifact, String classifier, SourceResolverConfig config) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), classifier, "jar", artifact.getVersion());
    }

    private Collection<Path> resolveAndUnpack(List<org.eclipse.aether.artifact.Artifact> artifacts, SourceResolverConfig config, List<String> validClassifiers, boolean propagateErrors) throws ArtifactResolutionException {
        LinkedHashSet<org.eclipse.aether.artifact.Artifact> artifactSet = new LinkedHashSet<org.eclipse.aether.artifact.Artifact>(artifacts);
        AndDependencyFilter filter = config.filter() != null ? new EclipseAetherFilterTransformer().transform(config.filter()) : null;
        ArrayList<Path> result = new ArrayList<Path>(artifacts.size());
        for (org.eclipse.aether.artifact.Artifact a : artifactSet) {
            Artifact resolvedArtifact;
            if (!validClassifiers.contains(a.getClassifier()) || filter != null && !filter.accept((DependencyNode)new DefaultDependencyNode(a), Collections.emptyList())) continue;
            ArtifactRequest req = new ArtifactRequest(a, config.project().getRemoteProjectRepositories(), null);
            try {
                RepositorySystemSession repoSession = config.getBuildingRequest().getRepositorySession();
                ArtifactResult resolutionResult = this.repoSystem.resolveArtifact(repoSession, req);
                resolvedArtifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)resolutionResult.getArtifact());
            }
            catch (org.eclipse.aether.resolution.ArtifactResolutionException e) {
                continue;
            }
            File d = new File(config.outputBasedir(), a.getArtifactId() + "-" + a.getVersion() + "-" + a.getClassifier());
            if (!d.exists()) {
                d.mkdirs();
            }
            try {
                UnArchiver unArchiver = this.archiverManager.getUnArchiver(a.getExtension());
                unArchiver.setDestDirectory(d);
                unArchiver.setSourceFile(resolvedArtifact.getFile());
                unArchiver.extract();
                result.add(d.toPath().toAbsolutePath());
            }
            catch (NoSuchArchiverException e) {
                if (!propagateErrors) continue;
                throw new ArtifactResolutionException("Failed to retrieve valid un-archiver component: " + a.getExtension(), RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)a), (Throwable)e);
            }
            catch (ArchiverException e) {
                if (!propagateErrors) continue;
                throw new ArtifactResolutionException("Failed to unpack: " + a, RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)a), (Throwable)e);
            }
        }
        return result;
    }

    private static Collection<Path> resolveFromProject(SourceResolverConfig config, MavenProject reactorProject, Artifact artifact) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (config.filter() == null || new ArtifactIncludeFilterTransformer().transform(config.filter()).include(artifact)) {
            List srcRoots;
            if (config.includeCompileSources()) {
                srcRoots = reactorProject.getCompileSourceRoots();
                dirs.addAll(srcRoots);
            }
            if (config.includeTestSources()) {
                srcRoots = reactorProject.getTestCompileSourceRoots();
                dirs.addAll(srcRoots);
            }
        }
        return JavadocUtil.pruneDirs(reactorProject, dirs);
    }
}

