/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jarsigner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class TsaSelector {
    private final ThreadLocal<TsaServer> currentTsaServer = new ThreadLocal();
    private final List<TsaServer> tsaServers;

    TsaSelector(String[] tsa, String[] tsacert, String[] tsapolicyid, String tsadigestalg) {
        ArrayList<TsaServer> tsaServersTmp = new ArrayList<TsaServer>();
        for (int i = 0; i < Math.max(tsa.length, tsacert.length); ++i) {
            String tsaUrl = i < tsa.length ? tsa[i] : null;
            String tsaAlias = i < tsacert.length ? tsacert[i] : null;
            String tsaPolicyId = i < tsapolicyid.length ? tsapolicyid[i] : null;
            tsaServersTmp.add(new TsaServer(tsaUrl, tsaAlias, tsaPolicyId, tsadigestalg));
        }
        if (tsaServersTmp.isEmpty()) {
            tsaServersTmp.add(TsaServer.EMPTY);
        }
        this.tsaServers = Collections.unmodifiableList(tsaServersTmp);
    }

    TsaServer getServer() {
        TsaServer best = this.tsaServers.get(0);
        for (int i = 1; i < this.tsaServers.size(); ++i) {
            if (best.failureCount.get() <= this.tsaServers.get(i).failureCount.get()) continue;
            best = this.tsaServers.get(i);
        }
        this.currentTsaServer.set(best);
        return best;
    }

    void registerFailure() {
        if (this.currentTsaServer.get() != null) {
            this.currentTsaServer.get().failureCount.incrementAndGet();
        }
    }

    static class TsaServer {
        private static final TsaServer EMPTY = new TsaServer(null, null, null, null);
        private final AtomicInteger failureCount = new AtomicInteger(0);
        private final String tsaUrl;
        private final String tsaAlias;
        private final String tsaPolicyId;
        private final String tsaDigestAlt;

        private TsaServer(String tsaUrl, String tsaAlias, String tsaPolicyId, String tsaDigestAlt) {
            this.tsaUrl = tsaUrl;
            this.tsaAlias = tsaAlias;
            this.tsaPolicyId = tsaPolicyId;
            this.tsaDigestAlt = tsaDigestAlt;
        }

        String getTsaUrl() {
            return this.tsaUrl;
        }

        String getTsaAlias() {
            return this.tsaAlias;
        }

        String getTsaPolicyId() {
            return this.tsaPolicyId;
        }

        String getTsaDigestAlt() {
            return this.tsaDigestAlt;
        }
    }
}

