/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.PathSelector;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.SourceFile;

final class PathFilter
extends SimpleFileVisitor<Path> {
    private final boolean useDefaultInclude;
    private final String[] includes;
    private final String[] excludes;
    private PathMatcher matchers;
    private final Collection<String> incrementalExcludes;
    private PathMatcher incrementalExcludeMatchers;
    private List<SourceFile> sourceFiles;
    private SourceDirectory sourceRoot;

    PathFilter(AbstractCompilerMojo mojo) {
        Collection<String> specified = mojo.getIncludes();
        this.useDefaultInclude = specified.isEmpty();
        if (this.useDefaultInclude) {
            specified = List.of("**");
        }
        this.includes = (String[])specified.toArray(String[]::new);
        this.excludes = (String[])mojo.getExcludes().toArray(String[]::new);
        this.incrementalExcludes = mojo.getIncrementalExcludes();
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.matchers.matches(file)) {
            this.sourceFiles.add(new SourceFile(this.sourceRoot, file, attrs, this.incrementalExcludeMatchers != null && this.incrementalExcludeMatchers.matches(file)));
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return Files.isHidden(dir) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
    }

    public List<SourceFile> walkSourceFiles(Iterable<SourceDirectory> rootDirectories) throws IOException {
        ArrayList<SourceFile> result = new ArrayList<SourceFile>();
        try {
            this.sourceFiles = result;
            for (SourceDirectory directory : rootDirectories) {
                if (!this.incrementalExcludes.isEmpty()) {
                    this.incrementalExcludeMatchers = new PathSelector(directory.root, this.incrementalExcludes, null).simplify();
                }
                String[] includesOrDefault = this.includes;
                if (this.useDefaultInclude) {
                    if (directory.includes.isEmpty()) {
                        includesOrDefault[0] = "glob:**" + directory.fileKind.extension;
                    } else {
                        includesOrDefault = null;
                    }
                }
                this.sourceRoot = directory;
                this.matchers = new PathSelector(directory.root, PathFilter.concat(directory.includes, includesOrDefault), PathFilter.concat(directory.excludes, this.excludes)).simplify();
                Files.walkFileTree(directory.root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, this);
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        finally {
            this.sourceRoot = null;
            this.sourceFiles = null;
            this.matchers = null;
        }
        return result;
    }

    private static List<String> concat(List<String> source, String[] plugin) {
        if (plugin == null || plugin.length == 0) {
            return source;
        }
        ArrayList<String> patterns = new ArrayList<String>(source);
        patterns.addAll(Arrays.asList(plugin));
        return patterns;
    }
}

