/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.tools.JavaCompiler;
import javax.tools.OptionChecker;
import org.apache.maven.api.Dependency;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.PathType;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.CompilationTaskSources;
import org.apache.maven.plugin.compiler.Options;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.SourcesForRelease;

@Mojo(name="testCompile", defaultPhase="test-compile")
public class TestCompilerMojo
extends AbstractCompilerMojo {
    @Parameter(property="maven.test.skip")
    protected boolean skip;
    @Parameter
    protected List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/test-annotations")
    protected Path generatedTestSourcesDirectory;
    @Parameter
    protected Set<String> testIncludes;
    @Parameter
    protected Set<String> testExcludes;
    @Parameter
    protected Set<String> testIncrementalExcludes;
    @Parameter(property="maven.compiler.testSource")
    protected String testSource;
    @Parameter(property="maven.compiler.testTarget")
    protected String testTarget;
    @Parameter(property="maven.compiler.testRelease")
    protected String testRelease;
    @Parameter
    protected List<String> testCompilerArgs;
    @Parameter
    @Deprecated(since="4.0.0")
    protected Map<String, String> testCompilerArguments;
    @Parameter
    @Deprecated(since="4.0.0")
    protected String testCompilerArgument;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    protected Path outputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    protected Path mainOutputDirectory;
    @Deprecated(since="4.0.0")
    @Parameter(defaultValue="true")
    protected boolean useModulePath = true;
    private String moduleName;
    private boolean hasTestModuleInfo;
    private boolean overwriteMainModuleInfo;
    @Parameter(defaultValue="javac-test.args")
    protected String debugFileName;

    public TestCompilerMojo() {
        super(true);
    }

    @Override
    public void execute() throws MojoException {
        if (this.skip) {
            this.logger.info((CharSequence)"Not compiling test sources");
            return;
        }
        super.execute();
    }

    @Override
    protected Options acceptParameters(OptionChecker compiler) {
        Options compilerConfiguration = super.acceptParameters(compiler);
        compilerConfiguration.addUnchecked((Iterable<String>)(this.testCompilerArgs == null || this.testCompilerArgs.isEmpty() ? this.compilerArgs : this.testCompilerArgs));
        if (this.testCompilerArguments != null) {
            for (Map.Entry<String, String> entry : this.testCompilerArguments.entrySet()) {
                compilerConfiguration.addUnchecked(List.of(entry.getKey(), entry.getValue()));
            }
        }
        compilerConfiguration.addUnchecked(this.testCompilerArgument == null ? this.compilerArgument : this.testCompilerArgument);
        return compilerConfiguration;
    }

    @Override
    @Nonnull
    protected List<Path> getCompileSourceRoots() {
        if (this.compileSourceRoots == null || this.compileSourceRoots.isEmpty()) {
            return this.projectManager.getCompileSourceRoots(this.project, ProjectScope.TEST);
        }
        return this.compileSourceRoots.stream().map(x$0 -> Paths.get(x$0, new String[0])).toList();
    }

    @Override
    @Nullable
    protected Path getGeneratedSourcesDirectory() {
        return this.generatedTestSourcesDirectory;
    }

    @Override
    protected Set<String> getIncludes() {
        return this.testIncludes != null ? this.testIncludes : Set.of();
    }

    @Override
    protected Set<String> getExcludes() {
        return this.testExcludes != null ? this.testExcludes : Set.of();
    }

    @Override
    protected Set<String> getIncrementalExcludes() {
        return this.testIncrementalExcludes != null ? this.testIncrementalExcludes : Set.of();
    }

    @Override
    @Nullable
    protected String getSource() {
        return this.testSource == null ? this.source : this.testSource;
    }

    @Override
    @Nullable
    protected String getTarget() {
        return this.testTarget == null ? this.target : this.testTarget;
    }

    @Override
    @Nullable
    protected String getRelease() {
        return this.testRelease == null ? this.release : this.testRelease;
    }

    @Override
    @Nonnull
    protected Path getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    @Nullable
    protected String getDebugFileName() {
        return this.debugFileName;
    }

    private String getMainModuleName() throws IOException {
        if (this.moduleName == null) {
            Path file = this.mainOutputDirectory.resolve("module-info.class");
            if (Files.isRegularFile(file, new LinkOption[0])) {
                try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                    this.moduleName = ModuleDescriptor.read(in).name();
                }
            } else {
                this.moduleName = "";
            }
        }
        return this.moduleName;
    }

    private String getTestModuleName(List<SourceDirectory> compileSourceRoots) throws IOException {
        for (SourceDirectory directory : compileSourceRoots) {
            if (directory.moduleName != null) {
                return directory.moduleName;
            }
            String name = this.parseModuleInfoName(directory.getModuleInfo().orElse(null));
            if (name == null) continue;
            return name;
        }
        return null;
    }

    @Override
    final boolean hasModuleDeclaration(List<SourceDirectory> roots) throws IOException {
        this.hasTestModuleInfo = super.hasModuleDeclaration(roots);
        if (this.hasTestModuleInfo) {
            MessageBuilder message = this.messageBuilderFactory.builder();
            message.a((CharSequence)"Overwriting the ").warning((Object)"module-info.java").a((CharSequence)" file in the test directory is deprecated. Use ").info((Object)"--add-reads").a((CharSequence)", ").info((Object)"--add-modules").a((CharSequence)" and related options instead.");
            this.logger.warn((CharSequence)message.toString());
            return this.useModulePath;
        }
        return this.useModulePath && !this.getMainModuleName().isEmpty();
    }

    @Override
    protected void addImplicitDependencies(Map<PathType, List<Path>> addTo, boolean hasModuleDeclaration) {
        JavaPathType pathType;
        JavaPathType javaPathType = pathType = hasModuleDeclaration ? JavaPathType.MODULES : JavaPathType.CLASSES;
        if (Files.exists(this.mainOutputDirectory, new LinkOption[0])) {
            addTo.computeIfAbsent((PathType)pathType, key -> new ArrayList()).add(this.mainOutputDirectory);
        }
    }

    @Override
    final void addSourceDirectories(Map<PathType, List<Path>> addTo, List<SourceDirectory> compileSourceRoots) throws IOException {
        for (SourceDirectory dir : compileSourceRoots) {
            String moduleToPatch = dir.moduleName;
            if (moduleToPatch == null) {
                moduleToPatch = this.getMainModuleName();
                if (moduleToPatch.isEmpty()) continue;
                String testModuleName = this.getTestModuleName(compileSourceRoots);
                if (testModuleName != null) {
                    this.overwriteMainModuleInfo = testModuleName.equals(this.getMainModuleName());
                    if (!this.overwriteMainModuleInfo) continue;
                }
            }
            addTo.computeIfAbsent((PathType)JavaPathType.patchModule((String)moduleToPatch), key -> new ArrayList()).add(dir.root);
        }
    }

    @Override
    protected void addModuleOptions(DependencyResolverResult dependencies, Options addTo) throws IOException {
        if (this.useModulePath && this.hasTestModuleInfo) {
            return;
        }
        HashSet<String> done = new HashSet<String>();
        StringJoiner addModules = new StringJoiner(",");
        StringJoiner addReads = null;
        boolean hasUnnamed = false;
        for (Map.Entry entry : dependencies.getDependencies().entrySet()) {
            boolean compile = false;
            switch (((Dependency)entry.getKey()).getScope()) {
                case TEST: 
                case TEST_ONLY: {
                    compile = true;
                }
                case TEST_RUNTIME: {
                    Path path;
                    String name;
                    if (compile && addReads == null) {
                        addReads = new StringJoiner(",", this.getMainModuleName() + "=", "");
                    }
                    if ((name = (String)dependencies.getModuleName(path = (Path)entry.getValue()).orElse(null)) == null) {
                        hasUnnamed = true;
                        break;
                    }
                    if (!done.add(name)) break;
                    addModules.add(name);
                    if (compile) {
                        addReads.add(name);
                    }
                    dependencies.getModuleDescriptor(path).ifPresent(descriptor -> {
                        for (ModuleDescriptor.Requires r : descriptor.requires()) {
                            done.add(r.name());
                        }
                    });
                }
            }
        }
        if (!done.isEmpty()) {
            addTo.addIfNonBlank("--add-modules", addModules.toString());
        }
        if (addReads != null) {
            if (hasUnnamed) {
                addReads.add("ALL-UNNAMED");
            }
            addTo.addIfNonBlank("--add-reads", addReads.toString());
        }
    }

    @Override
    final CompilationTaskSources[] toCompilationTasks(final SourcesForRelease unit) {
        if (!(this.useModulePath && this.hasTestModuleInfo && this.overwriteMainModuleInfo)) {
            return super.toCompilationTasks(unit);
        }
        CompilationTaskSources moduleInfo = null;
        List<Path> files = unit.files;
        int i = files.size();
        while (--i >= 0) {
            if (!SourceDirectory.isModuleInfoSource(files.get(i))) continue;
            moduleInfo = new CompilationTaskSources(List.of(files.remove(i)));
            if (!files.isEmpty()) break;
            return new CompilationTaskSources[]{moduleInfo};
        }
        CompilationTaskSources task = new CompilationTaskSources(files){

            @Override
            boolean compile(JavaCompiler.CompilationTask task) throws IOException {
                try (SourcesForRelease sourcesForRelease = unit;){
                    unit.substituteModuleInfos(TestCompilerMojo.this.mainOutputDirectory, TestCompilerMojo.this.outputDirectory);
                    boolean bl = super.compile(task);
                    return bl;
                }
            }
        };
        if (moduleInfo != null) {
            return new CompilationTaskSources[]{moduleInfo, task};
        }
        return new CompilationTaskSources[]{task};
    }
}

