/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.tools.OptionChecker;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.PathType;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.Options;

@Mojo(name="compile", defaultPhase="compile")
public class CompilerMojo
extends AbstractCompilerMojo {
    @Parameter(property="maven.main.skip")
    protected boolean skipMain;
    @Parameter
    protected List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/annotations")
    protected Path generatedSourcesDirectory;
    @Parameter
    protected Set<String> includes;
    @Parameter
    protected Set<String> excludes;
    @Parameter
    protected Set<String> incrementalExcludes;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    protected Path outputDirectory;
    @Parameter(defaultValue="${project.mainArtifact}", readonly=true, required=true)
    protected ProducedArtifact projectArtifact;
    @Parameter
    @Deprecated(since="4.0.0")
    protected boolean multiReleaseOutput;
    @Parameter(defaultValue="javac.args")
    protected String debugFileName;

    public CompilerMojo() {
        super(false);
    }

    @Override
    public void execute() throws MojoException {
        if (this.skipMain) {
            this.logger.info((CharSequence)"Not compiling main sources");
            return;
        }
        super.execute();
        Path outputDirectory = this.getOutputDirectory();
        if (Files.isDirectory(outputDirectory, new LinkOption[0]) && this.projectArtifact != null) {
            this.artifactManager.setPath(this.projectArtifact, outputDirectory);
        }
    }

    @Override
    protected Options acceptParameters(OptionChecker compiler) {
        Options compilerConfiguration = super.acceptParameters(compiler);
        compilerConfiguration.addUnchecked(this.compilerArgs);
        compilerConfiguration.addUnchecked(this.compilerArgument);
        return compilerConfiguration;
    }

    @Override
    @Nonnull
    protected List<Path> getCompileSourceRoots() {
        List<Path> sources = this.compileSourceRoots == null || this.compileSourceRoots.isEmpty() ? this.projectManager.getCompileSourceRoots(this.project, ProjectScope.MAIN) : this.compileSourceRoots.stream().map(x$0 -> Paths.get(x$0, new String[0])).toList();
        return sources;
    }

    @Override
    @Nullable
    protected Path getGeneratedSourcesDirectory() {
        return this.generatedSourcesDirectory;
    }

    @Override
    protected Set<String> getIncludes() {
        return this.includes != null ? this.includes : Set.of();
    }

    @Override
    protected Set<String> getExcludes() {
        return this.excludes != null ? this.excludes : Set.of();
    }

    @Override
    protected Set<String> getIncrementalExcludes() {
        return this.incrementalExcludes != null ? this.incrementalExcludes : Set.of();
    }

    @Override
    @Nonnull
    protected Path getOutputDirectory() {
        if (this.multiReleaseOutput && this.release != null) {
            return this.outputDirectory.resolve(Path.of("META-INF", "versions", this.release));
        }
        return this.outputDirectory;
    }

    @Override
    @Nullable
    protected String getDebugFileName() {
        return this.debugFileName;
    }

    @Override
    @Deprecated(since="4.0.0")
    protected void addImplicitDependencies(Map<PathType, List<Path>> addTo, boolean hasModuleDeclaration) throws IOException {
        if (this.multiReleaseOutput) {
            TreeMap paths = new TreeMap();
            Path root = this.outputDirectory.resolve(Path.of("META-INF", "versions"));
            Files.walk(root, 1, new FileVisitOption[0]).forEach(path -> {
                int version;
                if (path.equals(root)) {
                    path = this.outputDirectory;
                    version = 0;
                } else {
                    try {
                        version = Integer.parseInt(path.getFileName().toString());
                    }
                    catch (NumberFormatException e) {
                        throw new CompilationFailureException("Invalid version number for " + String.valueOf(path), e);
                    }
                }
                if (paths.put(version, path) != null) {
                    throw new CompilationFailureException("Duplicated version number for " + String.valueOf(path));
                }
            });
            String moduleName = null;
            for (Path path2 : paths.values()) {
                if (!Files.exists(path2 = path2.resolve("module-info.class"), new LinkOption[0])) continue;
                try (InputStream in = Files.newInputStream(path2, new OpenOption[0]);){
                    moduleName = ModuleDescriptor.read(in).name();
                    break;
                }
            }
            if (moduleName == null) {
                Path path2;
                Iterator<Object> iterator = this.getCompileSourceRoots().iterator();
                while (iterator.hasNext() && (moduleName = this.parseModuleInfoName((path2 = (Path)iterator.next()).resolve("module-info.java"))) == null) {
                }
            }
            JavaPathType pathType = moduleName != null ? JavaPathType.patchModule(moduleName) : JavaPathType.CLASSES;
            addTo.computeIfAbsent((PathType)pathType, key -> new ArrayList()).addAll(paths.descendingMap().values());
        }
    }
}

