/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.clean;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.maven.api.Event;
import org.apache.maven.api.EventType;
import org.apache.maven.api.Listener;
import org.apache.maven.api.Session;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.plugins.clean.Selector;
import org.codehaus.plexus.util.Os;

class Cleaner {
    private static final boolean ON_WINDOWS = Os.isFamily((String)"windows");
    private static final SessionData.Key<Path> LAST_DIRECTORY_TO_DELETE = SessionData.key(Path.class, (Object)(Cleaner.class.getName() + ".lastDirectoryToDelete"));
    private final Session session;
    private final Logger logDebug;
    private final Logger logInfo;
    private final Logger logVerbose;
    private final Logger logWarn;
    private final Path fastDir;
    private final String fastMode;

    Cleaner(Session session, Log log, boolean verbose, Path fastDir, String fastMode) {
        this.logDebug = log == null || !log.isDebugEnabled() ? null : this.logger(arg_0 -> ((Log)log).debug(arg_0), (arg_0, arg_1) -> ((Log)log).debug(arg_0, arg_1));
        this.logInfo = log == null || !log.isInfoEnabled() ? null : this.logger(arg_0 -> ((Log)log).info(arg_0), (arg_0, arg_1) -> ((Log)log).info(arg_0, arg_1));
        this.logWarn = log == null || !log.isWarnEnabled() ? null : this.logger(arg_0 -> ((Log)log).warn(arg_0), (arg_0, arg_1) -> ((Log)log).warn(arg_0, arg_1));
        this.logVerbose = verbose ? this.logInfo : this.logDebug;
        this.session = session;
        this.fastDir = fastDir;
        this.fastMode = fastMode;
    }

    private Logger logger(final Consumer<CharSequence> l1, final BiConsumer<CharSequence, Throwable> l2) {
        return new Logger(){

            @Override
            public void log(CharSequence message) {
                l1.accept(message);
            }

            @Override
            public void log(CharSequence message, Throwable t) {
                l2.accept(message, t);
            }
        };
    }

    public void delete(Path basedir, Selector selector, boolean followSymlinks, boolean failOnError, boolean retryOnError) throws IOException {
        Path file;
        if (!Files.isDirectory(basedir, new LinkOption[0])) {
            if (!Files.exists(basedir, new LinkOption[0])) {
                if (this.logDebug != null) {
                    this.logDebug.log("Skipping non-existing directory " + String.valueOf(basedir));
                }
                return;
            }
            throw new IOException("Invalid base directory " + String.valueOf(basedir));
        }
        if (this.logInfo != null) {
            this.logInfo.log("Deleting " + String.valueOf(basedir) + (String)(selector != null ? " (" + String.valueOf(selector) + ")" : ""));
        }
        Path path = file = followSymlinks ? basedir : Cleaner.getCanonicalPath(basedir);
        if (selector == null && !followSymlinks && this.fastDir != null && this.session != null && this.fastDelete(file)) {
            return;
        }
        this.delete(file, "", selector, followSymlinks, failOnError, retryOnError);
    }

    private boolean fastDelete(Path baseDir) {
        Path fastDir = this.fastDir;
        if (fastDir.toAbsolutePath().startsWith(baseDir.toAbsolutePath())) {
            try {
                String prefix = baseDir.getFileName().toString() + ".";
                Path tmpDir = Files.createTempDirectory(baseDir.getParent(), prefix, new FileAttribute[0]);
                try {
                    Files.move(baseDir, tmpDir, StandardCopyOption.REPLACE_EXISTING);
                    if (this.session != null) {
                        this.session.getData().set(LAST_DIRECTORY_TO_DELETE, (Object)baseDir);
                    }
                    baseDir = tmpDir;
                }
                catch (IOException e) {
                    Files.delete(tmpDir);
                    throw e;
                }
            }
            catch (IOException e) {
                if (this.logDebug != null) {
                    this.logDebug.log("Unable to fast delete directory", e);
                }
                return false;
            }
        }
        try {
            if (!Files.isDirectory(fastDir, new LinkOption[0])) {
                Files.createDirectories(fastDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            if (this.logDebug != null) {
                this.logDebug.log("Unable to fast delete directory as the path " + String.valueOf(fastDir) + " does not point to a directory or cannot be created", e);
            }
            return false;
        }
        try {
            Path tmpDir = Files.createTempDirectory(fastDir, "", new FileAttribute[0]);
            Path dstDir = tmpDir.resolve(baseDir.getFileName());
            Files.move(baseDir, dstDir, StandardCopyOption.ATOMIC_MOVE);
            BackgroundCleaner.delete(this, tmpDir, this.fastMode);
            return true;
        }
        catch (IOException e) {
            if (this.logDebug != null) {
                this.logDebug.log("Unable to fast delete directory", e);
            }
            return false;
        }
    }

    private Result delete(Path file, String pathname, Selector selector, boolean followSymlinks, boolean failOnError, boolean retryOnError) throws IOException {
        Result result = new Result();
        boolean isDirectory = Files.isDirectory(file, new LinkOption[0]);
        if (isDirectory) {
            if (selector == null || selector.couldHoldSelected(pathname)) {
                Path canonical;
                boolean isSymlink = this.isSymbolicLink(file);
                Path path = canonical = followSymlinks ? file : Cleaner.getCanonicalPath(file);
                if (followSymlinks || !isSymlink) {
                    String prefix = !pathname.isEmpty() ? pathname + File.separatorChar : "";
                    try (Stream<Path> children = Files.list(canonical);){
                        for (Path child : children.toList()) {
                            result.update(this.delete(child, prefix + String.valueOf(child.getFileName()), selector, followSymlinks, failOnError, retryOnError));
                        }
                    }
                } else if (this.logDebug != null) {
                    this.logDebug.log("Not recursing into symlink " + String.valueOf(file));
                }
            } else if (this.logDebug != null) {
                this.logDebug.log("Not recursing into directory without included files " + String.valueOf(file));
            }
        }
        if (!result.excluded && (selector == null || selector.isSelected(pathname))) {
            if (this.logVerbose != null) {
                if (isDirectory) {
                    this.logVerbose.log("Deleting directory " + String.valueOf(file));
                } else if (Files.exists(file, new LinkOption[0])) {
                    this.logVerbose.log("Deleting file " + String.valueOf(file));
                } else {
                    this.logVerbose.log("Deleting dangling symlink " + String.valueOf(file));
                }
            }
            result.failures += this.delete(file, failOnError, retryOnError);
        } else {
            result.excluded = true;
        }
        return result;
    }

    private static Path getCanonicalPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return Cleaner.getCanonicalPath(path.getParent()).resolve(path.getFileName());
        }
    }

    private boolean isSymbolicLink(Path path) throws IOException {
        BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        return attrs.isSymbolicLink() || attrs.isDirectory() && attrs.isOther();
    }

    private int delete(Path file, boolean failOnError, boolean retryOnError) throws IOException {
        IOException failure = Cleaner.delete(file);
        if (failure != null) {
            if (retryOnError) {
                int[] delays;
                if (ON_WINDOWS) {
                    System.gc();
                }
                for (int delay : delays = new int[]{50, 250, 750}) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                    failure = Cleaner.delete(file);
                    if (failure == null) break;
                }
            }
            if (Files.exists(file, new LinkOption[0])) {
                if (failOnError) {
                    throw new IOException("Failed to delete " + String.valueOf(file), failure);
                }
                if (this.logWarn != null) {
                    this.logWarn.log("Failed to delete " + String.valueOf(file), failure);
                }
                return 1;
            }
        }
        return 0;
    }

    private static IOException delete(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }

    private static interface Logger {
        public void log(CharSequence var1);

        public void log(CharSequence var1, Throwable var2);
    }

    private static class Result {
        private int failures;
        private boolean excluded;

        private Result() {
        }

        public void update(Result result) {
            this.failures += result.failures;
            this.excluded |= result.excluded;
        }
    }

    private static class BackgroundCleaner
    extends Thread {
        private static BackgroundCleaner instance;
        private final Deque<Path> filesToDelete = new ArrayDeque<Path>();
        private final Cleaner cleaner;
        private final String fastMode;
        private static final int NEW = 0;
        private static final int RUNNING = 1;
        private static final int STOPPED = 2;
        private int status = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void delete(Cleaner cleaner, Path dir, String fastMode) {
            Class<BackgroundCleaner> clazz = BackgroundCleaner.class;
            synchronized (BackgroundCleaner.class) {
                if (instance == null || !instance.doDelete(dir)) {
                    instance = new BackgroundCleaner(cleaner, dir, fastMode);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void sessionEnd() {
            Class<BackgroundCleaner> clazz = BackgroundCleaner.class;
            synchronized (BackgroundCleaner.class) {
                if (instance != null) {
                    instance.doSessionEnd();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        private BackgroundCleaner(Cleaner cleaner, Path dir, String fastMode) {
            super("mvn-background-cleaner");
            this.cleaner = cleaner;
            this.fastMode = fastMode;
            this.init(cleaner.fastDir, dir);
        }

        @Override
        public void run() {
            Path basedir;
            while ((basedir = this.pollNext()) != null) {
                try {
                    this.cleaner.delete(basedir, "", null, false, false, true);
                }
                catch (IOException iOException) {}
            }
        }

        synchronized void init(Path fastDir, Path dir) {
            if (Files.isDirectory(fastDir, new LinkOption[0])) {
                try (Stream<Path> children = Files.list(fastDir);){
                    children.forEach(this::doDelete);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.doDelete(dir);
        }

        synchronized Path pollNext() {
            Path basedir = this.filesToDelete.poll();
            if (basedir == null) {
                SessionData data;
                Path lastDir;
                if (this.cleaner.session != null && (lastDir = (Path)(data = this.cleaner.session.getData()).get(LAST_DIRECTORY_TO_DELETE)) != null) {
                    data.set(LAST_DIRECTORY_TO_DELETE, null);
                    return lastDir;
                }
                this.status = 2;
                this.notifyAll();
            }
            return basedir;
        }

        synchronized boolean doDelete(Path dir) {
            if (this.status == 2) {
                return false;
            }
            this.filesToDelete.add(dir);
            if (this.status == 0 && "background".equals(this.fastMode)) {
                this.status = 1;
                this.notifyAll();
                this.start();
            }
            this.wrapExecutionListener();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wrapExecutionListener() {
            Class<CleanerListener> clazz = CleanerListener.class;
            synchronized (CleanerListener.class) {
                if (this.cleaner.session.getListeners().stream().noneMatch(l -> l instanceof CleanerListener)) {
                    this.cleaner.session.registerListener((Listener)new CleanerListener());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        synchronized void doSessionEnd() {
            if (this.status != 2) {
                if (this.status == 0) {
                    this.start();
                }
                if (!"defer".equals(this.fastMode)) {
                    try {
                        if (this.cleaner.logInfo != null) {
                            this.cleaner.logInfo.log("Waiting for background file deletion");
                        }
                        while (this.status != 2) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static class CleanerListener
    implements Listener {
        CleanerListener() {
        }

        public void onEvent(Event event) {
            if (event.getType() == EventType.SESSION_ENDED) {
                BackgroundCleaner.sessionEnd();
            }
        }
    }
}

