/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.github;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.changes.issues.Issue;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GitHubBuilder;

public class GitHubDownloader {
    private GitHubBuilder client;
    private boolean includeOpenIssues;
    private boolean onlyMilestoneIssues;
    private String githubOwner;
    private String githubRepo;
    private String githubIssueURL;

    public GitHubDownloader(MavenProject project, boolean includeOpenIssues, boolean onlyMilestoneIssues) throws IOException {
        String[] urlPathParts;
        String urlPath;
        this.includeOpenIssues = includeOpenIssues;
        this.onlyMilestoneIssues = onlyMilestoneIssues;
        URL githubURL = new URL(project.getIssueManagement().getUrl());
        this.client = githubURL.getHost().equalsIgnoreCase("github.com") ? new GitHubBuilder() : new GitHubBuilder().withEndpoint(githubURL.getProtocol() + "://" + githubURL.getHost() + (githubURL.getPort() == -1 ? "" : ":" + githubURL.getPort()));
        this.githubIssueURL = project.getIssueManagement().getUrl();
        if (!this.githubIssueURL.endsWith("/")) {
            this.githubIssueURL = this.githubIssueURL + "/";
        }
        if ((urlPath = githubURL.getPath()).startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (urlPath.endsWith("/")) {
            urlPath = urlPath.substring(0, urlPath.length() - 2);
        }
        if ((urlPathParts = urlPath.split("/")).length != 3) {
            throw new MalformedURLException("GitHub issue management URL must look like, [GITHUB_DOMAIN]/[OWNER]/[REPO]/issues");
        }
        this.githubOwner = urlPathParts[0];
        this.githubRepo = urlPathParts[1];
    }

    protected Issue createIssue(GHIssue githubIssue) throws IOException {
        Issue issue = new Issue();
        issue.setKey(String.valueOf(githubIssue.getNumber()));
        issue.setId(String.valueOf(githubIssue.getNumber()));
        issue.setLink(this.githubIssueURL + githubIssue.getNumber());
        issue.setCreated(githubIssue.getCreatedAt());
        issue.setUpdated(githubIssue.getUpdatedAt());
        if (githubIssue.getAssignee() != null) {
            if (githubIssue.getAssignee().getName() != null) {
                issue.setAssignee(githubIssue.getAssignee().getName());
            } else {
                issue.setAssignee(githubIssue.getAssignee().getLogin());
            }
        }
        issue.setSummary(githubIssue.getTitle());
        if (githubIssue.getMilestone() != null) {
            issue.addFixVersion(githubIssue.getMilestone().getTitle());
        }
        issue.setReporter(githubIssue.getUser().getLogin());
        issue.setStatus(githubIssue.getState().name());
        Collection labels = githubIssue.getLabels();
        if (labels != null && !labels.isEmpty()) {
            issue.setType(((GHLabel)labels.stream().findAny().get()).getName());
        }
        return issue;
    }

    public List<Issue> getIssueList() throws IOException {
        ArrayList<Issue> issueList = new ArrayList<Issue>();
        if (this.includeOpenIssues) {
            List openIssues = this.client.build().getRepository(this.githubOwner + "/" + this.githubRepo).getIssues(GHIssueState.OPEN);
            for (GHIssue issue : openIssues) {
                if (this.onlyMilestoneIssues && issue.getMilestone() == null) continue;
                issueList.add(this.createIssue(issue));
            }
        }
        List closedIssues = this.client.build().getRepository(this.githubOwner + "/" + this.githubRepo).getIssues(GHIssueState.CLOSED);
        for (GHIssue issue : closedIssues) {
            if (this.onlyMilestoneIssues && issue.getMilestone() == null) continue;
            issueList.add(this.createIssue(issue));
        }
        return issueList;
    }

    public void configureAuthentication(SettingsDecrypter decrypter, String githubAPIServerId, Settings settings, Log log) {
        boolean configured = false;
        List servers = settings.getServers();
        for (Server server : servers) {
            if (!server.getId().equals(githubAPIServerId)) continue;
            SettingsDecryptionResult result = decrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
            for (SettingsProblem problem : result.getProblems()) {
                log.error((CharSequence)problem.getMessage(), (Throwable)problem.getException());
            }
            server = result.getServer();
            String password = server.getPassword();
            this.client.withJwtToken(password);
            configured = true;
            break;
        }
        if (!configured) {
            log.warn((CharSequence)("Can't find server id [" + githubAPIServerId + "] configured in settings.xml"));
        }
    }
}

