/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.github;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.changes.AbstractChangesReport;
import org.apache.maven.plugins.changes.ProjectUtils;
import org.apache.maven.plugins.changes.github.GitHubDownloader;
import org.apache.maven.plugins.changes.issues.Issue;
import org.apache.maven.plugins.changes.issues.IssueUtils;
import org.apache.maven.plugins.changes.issues.IssuesReportHelper;
import org.apache.maven.plugins.changes.issues.IssuesReportRenderer;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="github-changes", threadSafe=true)
public class GitHubChangesReport
extends AbstractChangesReport {
    private static final Map<String, Integer> GITHUB_COLUMNS = new HashMap<String, Integer>();
    @Parameter(defaultValue="Id,Type,Summary,Assignee,Reporter,Status,Created,Updated,Fix Version")
    private String columnNames;
    @Parameter(defaultValue="github")
    private String githubAPIServerId;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(defaultValue="true")
    private boolean includeOpenIssues;
    @Parameter(defaultValue="true")
    private boolean onlyMilestoneIssues;
    @Parameter(defaultValue="false")
    private boolean onlyCurrentVersion;
    private SettingsDecrypter settingsDecrypter;

    @Inject
    public GitHubChangesReport(SettingsDecrypter settingsDecrypter) {
        this.settingsDecrypter = settingsDecrypter;
    }

    @Deprecated
    public String getOutputName() {
        return "github-changes";
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.issues.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.issues.description");
    }

    public boolean canGenerateReport() {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the GitHub Report in this project because it's not the Execution Root");
            return false;
        }
        String message = ProjectUtils.validateIssueManagement(this.project, "GitHub", "GitHub Report");
        if (message != null) {
            this.getLog().warn((CharSequence)message);
        }
        return message == null;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        List<Integer> columnIds = IssuesReportHelper.getColumnIds(this.columnNames, GITHUB_COLUMNS);
        if (columnIds.isEmpty()) {
            throw new MavenReportException("maven-changes-plugin: None of the configured columnNames '" + this.columnNames + "' are valid.");
        }
        try {
            GitHubDownloader issueDownloader = new GitHubDownloader(this.project, this.includeOpenIssues, this.onlyMilestoneIssues);
            issueDownloader.configureAuthentication(this.settingsDecrypter, this.githubAPIServerId, this.settings, this.getLog());
            List<Issue> issueList = issueDownloader.getIssueList();
            if (this.onlyCurrentVersion) {
                issueList = IssueUtils.getIssuesForVersion(issueList, this.project.getVersion());
                this.getLog().info((CharSequence)"The GitHub Report will contain issues only for the current version.");
            }
            IssuesReportRenderer report = new IssuesReportRenderer(this.getSink(), this.getBundle(locale), columnIds, issueList);
            report.render();
        }
        catch (MalformedURLException e) {
            throw new MavenReportException("The Github URL is incorrect - " + e.getMessage());
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("github-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    static {
        GITHUB_COLUMNS.put("Assignee", 0);
        GITHUB_COLUMNS.put("Created", 2);
        GITHUB_COLUMNS.put("Fix Version", 3);
        GITHUB_COLUMNS.put("Id", 4);
        GITHUB_COLUMNS.put("Reporter", 7);
        GITHUB_COLUMNS.put("Status", 9);
        GITHUB_COLUMNS.put("Summary", 10);
        GITHUB_COLUMNS.put("Type", 11);
        GITHUB_COLUMNS.put("Updated", 12);
    }
}

