/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.announcement;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.changes.ChangesXML;
import org.apache.maven.plugins.changes.IssueAdapter;
import org.apache.maven.plugins.changes.ProjectUtils;
import org.apache.maven.plugins.changes.ReleaseUtils;
import org.apache.maven.plugins.changes.announcement.AbstractAnnouncementMojo;
import org.apache.maven.plugins.changes.github.GitHubDownloader;
import org.apache.maven.plugins.changes.github.GitHubIssueManagementSystem;
import org.apache.maven.plugins.changes.issues.Issue;
import org.apache.maven.plugins.changes.issues.IssueManagementSystem;
import org.apache.maven.plugins.changes.issues.IssueUtils;
import org.apache.maven.plugins.changes.jira.JIRAIssueManagementSystem;
import org.apache.maven.plugins.changes.jira.RestJiraDownloader;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.maven.plugins.changes.trac.TracDownloader;
import org.apache.maven.plugins.changes.trac.TracIssueManagmentSystem;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.codehaus.plexus.velocity.VelocityComponent;

@Mojo(name="announcement-generate", threadSafe=true)
public class AnnouncementMojo
extends AbstractAnnouncementMojo {
    private static final String CHANGES_XML = "changes.xml";
    private static final String JIRA = "JIRA";
    private static final String TRAC = "Trac";
    private static final String GIT_HUB = "GitHub";
    @Parameter(property="changes.announcementFile")
    private String announcementFile;
    @Parameter
    private Map<Object, Object> announceParameters;
    @Parameter(property="project.artifactId", readonly=true)
    private String artifactId;
    @Parameter(property="changes.developmentTeam", defaultValue="${project.name} team", required=true)
    private String developmentTeam;
    @Parameter(property="changes.finalName", defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(property="project.groupId", readonly=true)
    private String groupId;
    @Parameter(defaultValue="${project.description}")
    private String introduction;
    @Parameter
    private List<String> issueManagementSystems;
    @Parameter
    private Map<String, String> issueTypes;
    @Parameter(defaultValue="${project.build.directory}/announcement", required=true)
    private File announcementDirectory;
    @Parameter(property="project.packaging", readonly=true)
    private String packaging;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="changes.template", defaultValue="announcement.vm", required=true)
    private String template;
    @Parameter(property="changes.templateDirectory", defaultValue="org/apache/maven/plugins/changes/announcement", required=true)
    private String templateDirectory;
    @Parameter(property="changes.templateEncoding", defaultValue="${project.build.sourceEncoding}")
    private String templateEncoding;
    @Deprecated
    @Parameter(property="changes.useJql", defaultValue="false")
    private boolean useJql;
    @Parameter(property="project.url")
    private String url;
    @Parameter
    private String urlDownload;
    @Parameter(property="changes.version", defaultValue="${project.version}", required=true)
    private String version;
    @Parameter(defaultValue="${basedir}/src/changes/changes.xml")
    private File xmlPath;
    @Parameter
    private String filter;
    @Parameter(property="changes.jiraPassword")
    private String jiraPassword;
    @Parameter(property="changes.jiraUser")
    private String jiraUser;
    @Parameter(property="changes.jiraServerId")
    private String jiraServerId;
    @Parameter(property="changes.maxEntries", defaultValue="25", required=true)
    private int maxEntries;
    @Parameter(defaultValue="false")
    private boolean onlyCurrentVersion;
    @Parameter(property="changes.resolutionIds", defaultValue="Fixed")
    private String resolutionIds;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="changes.statusIds", defaultValue="Closed")
    private String statusIds;
    @Deprecated
    @Parameter(property="changes.webUser")
    private String webUser;
    @Deprecated
    @Parameter(property="changes.webPassword")
    private String webPassword;
    @Parameter(property="changes.versionPrefix")
    private String versionPrefix;
    @Parameter(property="changes.jiraConnectionTimeout", defaultValue="36000")
    private int jiraConnectionTimeout;
    @Parameter(property="changes.jiraReceiveTimout", defaultValue="32000")
    private int jiraReceiveTimout;
    @Parameter(property="changes.tracPassword")
    private String tracPassword;
    @Parameter(defaultValue="order=id")
    private String tracQuery;
    @Parameter(property="changes.tracUser")
    private String tracUser;
    @Parameter(defaultValue="github")
    private String githubAPIServerId;
    @Parameter(defaultValue="false")
    private boolean includeOpenIssues;
    private ChangesXML xml;
    private VelocityComponent velocity;
    private final SettingsDecrypter settingsDecrypter;

    @Inject
    public AnnouncementMojo(VelocityComponent velocity, SettingsDecrypter settingsDecrypter) {
        this.velocity = velocity;
        this.settingsDecrypter = settingsDecrypter;
    }

    public void execute() throws MojoExecutionException {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the announcement generation in this project because it's not the Execution Root");
        } else {
            String message;
            if (this.issueManagementSystems == null) {
                this.issueManagementSystems = new ArrayList<String>();
            }
            if (this.issueManagementSystems.isEmpty()) {
                this.issueManagementSystems.add(CHANGES_XML);
            }
            List<Release> releases = null;
            if (this.issueManagementSystems.contains(CHANGES_XML)) {
                if (this.getXmlPath().exists()) {
                    ChangesXML changesXML = new ChangesXML(this.getXmlPath(), this.getLog());
                    List<Release> changesReleases = changesXML.getReleaseList();
                    releases = ReleaseUtils.mergeReleases(null, changesReleases);
                    this.getLog().info((CharSequence)("Including issues from file " + this.getXmlPath() + " in announcement..."));
                } else {
                    this.getLog().warn((CharSequence)("changes.xml file " + this.getXmlPath().getAbsolutePath() + " does not exist."));
                }
            }
            if (this.issueManagementSystems.contains(JIRA)) {
                message = ProjectUtils.validateIssueManagement(this.project, JIRA, "JIRA announcement");
                if (message == null) {
                    List<Release> jiraReleases = this.getJiraReleases();
                    releases = ReleaseUtils.mergeReleases(releases, jiraReleases);
                    this.getLog().info((CharSequence)"Including issues from JIRA in announcement...");
                } else {
                    throw new MojoExecutionException("Something is wrong with the Issue Management section. " + message);
                }
            }
            if (this.issueManagementSystems.contains(TRAC)) {
                this.getLog().warn((CharSequence)"Trac integration is prepared for removal in next major version due to lack of maintainers");
                message = ProjectUtils.validateIssueManagement(this.project, TRAC, "Trac announcement");
                if (message == null) {
                    List<Release> tracReleases = this.getTracReleases();
                    releases = ReleaseUtils.mergeReleases(releases, tracReleases);
                    this.getLog().info((CharSequence)"Including issues from Trac in announcement...");
                } else {
                    throw new MojoExecutionException("Something is wrong with the Issue Management section. " + message);
                }
            }
            if (this.issueManagementSystems.contains(GIT_HUB)) {
                message = ProjectUtils.validateIssueManagement(this.project, GIT_HUB, "GitHub announcement");
                if (message == null) {
                    List<Release> gitHubReleases = this.getGitHubReleases();
                    releases = ReleaseUtils.mergeReleases(releases, gitHubReleases);
                    this.getLog().info((CharSequence)"Including issues from GitHub in announcement...");
                } else {
                    throw new MojoExecutionException("Something is wrong with the Issue Management section. " + message);
                }
            }
            if (releases == null || releases.isEmpty()) {
                throw new MojoExecutionException("No releases found in any of the configured issue management systems.");
            }
            this.doGenerate(releases);
        }
    }

    public void doGenerate(List<Release> releases) throws MojoExecutionException {
        String version = (this.versionPrefix == null ? "" : this.versionPrefix) + this.getVersion();
        this.getLog().debug((CharSequence)("Generating announcement for version [" + version + "]. Found these releases: " + ReleaseUtils.toString(releases)));
        this.doGenerate(releases, ReleaseUtils.getLatestRelease(releases, version));
    }

    protected void doGenerate(List<Release> releases, Release release) throws MojoExecutionException {
        try {
            ToolManager toolManager = new ToolManager(true);
            ToolContext context = toolManager.createContext();
            if (this.getIntroduction() == null || this.getIntroduction().isEmpty()) {
                this.setIntroduction(this.getUrl());
            }
            context.put("releases", releases);
            context.put("groupId", (Object)this.getGroupId());
            context.put("artifactId", (Object)this.getArtifactId());
            context.put("version", (Object)this.getVersion());
            context.put("packaging", (Object)this.getPackaging());
            context.put("url", (Object)this.getUrl());
            context.put("release", (Object)release);
            context.put("introduction", (Object)this.getIntroduction());
            context.put("developmentTeam", (Object)this.getDevelopmentTeam());
            context.put("finalName", (Object)this.getFinalName());
            context.put("urlDownload", (Object)this.getUrlDownload());
            context.put("project", (Object)this.project);
            if (this.announceParameters == null) {
                context.put("announceParameters", Collections.emptyMap());
            } else {
                context.put("announceParameters", this.announceParameters);
            }
            this.processTemplate((Context)context, this.announcementDirectory, this.template, this.announcementFile);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new MojoExecutionException("Resource not found.", (Exception)((Object)rnfe));
        }
        catch (VelocityException ve) {
            throw new MojoExecutionException(ve.toString(), (Exception)((Object)ve));
        }
    }

    public void processTemplate(Context context, File outputDirectory, String template, String announcementFile) throws VelocityException, MojoExecutionException {
        if (announcementFile == null || announcementFile.isEmpty()) {
            announcementFile = template;
        }
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Failed to create directory " + outputDirectory);
        }
        File f = new File(outputDirectory, announcementFile);
        VelocityEngine engine = this.velocity.getEngine();
        engine.setApplicationAttribute((Object)"baseDirectory", (Object)this.basedir);
        if (this.templateEncoding == null || this.templateEncoding.isEmpty()) {
            this.templateEncoding = Charset.defaultCharset().name();
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + this.templateEncoding + "; build is platform dependent!"));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), this.templateEncoding);){
            Template velocityTemplate = engine.getTemplate(this.templateDirectory + "/" + template, this.templateEncoding);
            velocityTemplate.merge(context, (Writer)writer);
            this.getLog().info((CharSequence)("Created template " + f));
        }
        catch (ResourceNotFoundException ex) {
            throw new ResourceNotFoundException("Template not found. ( " + this.templateDirectory + "/" + template + " )", (Throwable)ex);
        }
        catch (VelocityException ve) {
            throw ve;
        }
        catch (IOException | RuntimeException e) {
            throw new MojoExecutionException(e.toString(), e);
        }
    }

    protected List<Release> getJiraReleases() throws MojoExecutionException {
        RestJiraDownloader jiraDownloader = new RestJiraDownloader();
        jiraDownloader.setLog(this.getLog());
        jiraDownloader.setStatusIds(this.statusIds);
        jiraDownloader.setResolutionIds(this.resolutionIds);
        jiraDownloader.setMavenProject(this.project);
        jiraDownloader.setSettings(this.settings);
        jiraDownloader.setSettingsDecrypter(this.settingsDecrypter);
        jiraDownloader.setNbEntries(this.maxEntries);
        jiraDownloader.setOnlyCurrentVersion(this.onlyCurrentVersion);
        jiraDownloader.setVersionPrefix(this.versionPrefix);
        jiraDownloader.setFilter(this.filter);
        jiraDownloader.setJiraServerId(this.jiraServerId);
        if (this.jiraUser != null) {
            jiraDownloader.setJiraUser(this.jiraUser);
            jiraDownloader.setJiraPassword(this.jiraPassword);
        } else if (this.webUser != null) {
            jiraDownloader.setJiraUser(this.webUser);
            jiraDownloader.setJiraPassword(this.webPassword);
        }
        jiraDownloader.setConnectionTimeout(this.jiraConnectionTimeout);
        jiraDownloader.setReceiveTimout(this.jiraReceiveTimout);
        try {
            jiraDownloader.doExecute();
            List<Issue> issueList = jiraDownloader.getIssueList();
            if (this.versionPrefix != null && !this.versionPrefix.isEmpty()) {
                int originalNumberOfIssues = issueList.size();
                issueList = IssueUtils.filterIssuesWithVersionPrefix(issueList, this.versionPrefix);
                this.getLog().debug((CharSequence)("Filtered out " + issueList.size() + " issues of " + originalNumberOfIssues + " that matched the versionPrefix '" + this.versionPrefix + "'."));
            }
            if (this.onlyCurrentVersion) {
                String version = (this.versionPrefix == null ? "" : this.versionPrefix) + this.project.getVersion();
                issueList = IssueUtils.getIssuesForVersion(issueList, version);
                this.getLog().debug((CharSequence)"The JIRA Report will contain issues only for the current version.");
            }
            return this.getReleases(issueList, new JIRAIssueManagementSystem());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract issues from JIRA.", e);
        }
    }

    private List<Release> getReleases(List<Issue> issues, IssueManagementSystem ims) throws MojoExecutionException {
        if (this.issueTypes != null) {
            ims.applyConfiguration(this.issueTypes);
        }
        if (issues.isEmpty()) {
            return Collections.emptyList();
        }
        IssueAdapter adapter = new IssueAdapter(ims);
        return adapter.getReleases(issues);
    }

    protected List<Release> getTracReleases() throws MojoExecutionException {
        TracDownloader issueDownloader = new TracDownloader();
        issueDownloader.setProject(this.project);
        issueDownloader.setQuery(this.tracQuery);
        issueDownloader.setTracPassword(this.tracPassword);
        issueDownloader.setTracUser(this.tracUser);
        try {
            return this.getReleases(issueDownloader.getIssueList(), new TracIssueManagmentSystem());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract issues from Trac.", e);
        }
    }

    protected List<Release> getGitHubReleases() throws MojoExecutionException {
        try {
            GitHubDownloader issueDownloader = new GitHubDownloader(this.project, this.includeOpenIssues, true);
            issueDownloader.configureAuthentication(this.settingsDecrypter, this.githubAPIServerId, this.settings, this.getLog());
            return this.getReleases(issueDownloader.getIssueList(), new GitHubIssueManagementSystem());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract issues from GitHub.", e);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getDevelopmentTeam() {
        return this.developmentTeam;
    }

    public void setDevelopmentTeam(String developmentTeam) {
        this.developmentTeam = developmentTeam;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public void setIssueTypes(Map<String, String> issueTypes) {
        this.issueTypes = issueTypes;
    }

    public Map<String, String> getIssueTypes() {
        return this.issueTypes;
    }

    public File getAnnouncementDirectory() {
        return this.announcementDirectory;
    }

    public void setAnnouncementDirectory(File announcementDirectory) {
        this.announcementDirectory = announcementDirectory;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlDownload() {
        return this.urlDownload;
    }

    public void setUrlDownload(String urlDownload) {
        this.urlDownload = urlDownload;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ChangesXML getXml() {
        return this.xml;
    }

    public void setXml(ChangesXML xml) {
        this.xml = xml;
    }

    public File getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(File xmlPath) {
        this.xmlPath = xmlPath;
    }
}

