/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.changes.AbstractChangesMojo;
import org.apache.maven.plugins.changes.ChangesXML;
import org.apache.maven.plugins.changes.ReleaseUtils;
import org.apache.maven.plugins.changes.model.Release;

@Mojo(name="changes-check", threadSafe=true)
public class ChangesCheckMojo
extends AbstractChangesMojo {
    @Parameter(property="changes.releaseDateFormat", defaultValue="yyyy-MM-dd")
    private String releaseDateFormat;
    @Parameter(property="changes.releaseDateLocale")
    private String releaseDateLocale;
    @Parameter(property="changes.version", defaultValue="${project.version}", required=true)
    private String version;
    @Parameter(property="changes.xmlPath", defaultValue="src/changes/changes.xml")
    private File xmlPath;
    @Parameter(property="changes.skipSnapshots", defaultValue="false")
    private boolean skipSnapshots;

    public void execute() throws MojoExecutionException {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the changes check in this project because it's not the Execution Root");
        } else if (this.version.endsWith("-SNAPSHOT") && this.skipSnapshots) {
            this.getLog().info((CharSequence)("Skipping snapshot version '" + this.version + "'."));
        } else if (this.xmlPath.exists()) {
            ChangesXML xml = new ChangesXML(this.xmlPath, this.getLog());
            Release release = ReleaseUtils.getLatestRelease(xml.getReleaseList(), this.version);
            if (!ChangesCheckMojo.isValidDate(release.getDateRelease(), this.releaseDateFormat, this.releaseDateLocale)) {
                throw new MojoExecutionException("The file " + this.xmlPath.getAbsolutePath() + " has an invalid release date.");
            }
        } else {
            this.getLog().warn((CharSequence)("The file " + this.xmlPath.getAbsolutePath() + " does not exist."));
        }
    }

    protected static boolean isValidDate(String string, String pattern) {
        return ChangesCheckMojo.isValidDate(string, pattern, null);
    }

    protected static boolean isValidDate(String string, String pattern, String locale) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            return false;
        }
        try {
            Locale usedLocale = null;
            if (StringUtils.isEmpty((CharSequence)locale)) {
                usedLocale = Locale.getDefault();
            } else {
                Locale[] locales;
                for (Locale value : locales = Locale.getAvailableLocales()) {
                    if (!value.toString().equals(locale)) continue;
                    usedLocale = value;
                    break;
                }
                if (usedLocale == null) {
                    usedLocale = Locale.getDefault();
                }
            }
            SimpleDateFormat df = new SimpleDateFormat(pattern, usedLocale);
            df.parse(string);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

