/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.DefaultMojoAnnotationsScanner;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotatedClass;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScanner;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors.MojoAnnotationVisitor;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors.MojoFieldVisitor;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors.MojoMethodVisitor;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors.MojoParameterVisitor;
import org.codehaus.plexus.util.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.util.TraceSignatureVisitor;

public class MojoClassVisitor
extends ClassVisitor {
    private MojoAnnotatedClass mojoAnnotatedClass;
    private Map<String, MojoAnnotationVisitor> annotationVisitorMap = new HashMap<String, MojoAnnotationVisitor>();
    private List<MojoFieldVisitor> fieldVisitors = new ArrayList<MojoFieldVisitor>();
    private List<MojoMethodVisitor> methodVisitors = new ArrayList<MojoMethodVisitor>();
    private int version;

    public MojoClassVisitor() {
        super(589824);
    }

    public MojoAnnotatedClass getMojoAnnotatedClass() {
        return this.mojoAnnotatedClass;
    }

    public int getVersion() {
        return this.version;
    }

    public MojoAnnotationVisitor getAnnotationVisitor(Class<?> annotation) {
        return this.getAnnotationVisitor(annotation.getName());
    }

    public MojoAnnotationVisitor getAnnotationVisitor(String name) {
        return this.annotationVisitorMap.get(name);
    }

    public List<MojoFieldVisitor> findFieldWithAnnotation(Class<?> annotation) {
        return this.findFieldWithAnnotation(Collections.singleton(annotation.getName()));
    }

    public List<MojoFieldVisitor> findFieldWithAnnotation(Set<String> annotationClassNames) {
        ArrayList<MojoFieldVisitor> mojoFieldVisitors = new ArrayList<MojoFieldVisitor>();
        for (MojoFieldVisitor mojoFieldVisitor : this.fieldVisitors) {
            Map<String, MojoAnnotationVisitor> filedVisitorMap = mojoFieldVisitor.getAnnotationVisitorMap();
            if (!filedVisitorMap.keySet().stream().anyMatch(annotationClassNames::contains)) continue;
            mojoFieldVisitors.add(mojoFieldVisitor);
        }
        return mojoFieldVisitors;
    }

    public List<MojoParameterVisitor> findParameterVisitors() {
        return this.findParameterVisitors(new HashSet<String>(Arrays.asList(DefaultMojoAnnotationsScanner.PARAMETER_V3, "org.apache.maven.api.plugin.annotations.Parameter")));
    }

    public List<MojoParameterVisitor> findParameterVisitors(Set<String> annotationClassNames) {
        return Stream.concat(this.findFieldWithAnnotation(annotationClassNames).stream(), this.methodVisitors.stream().filter(method -> method.getAnnotationVisitorMap().keySet().stream().anyMatch(annotationClassNames::contains))).collect(Collectors.toList());
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.version = version;
        this.mojoAnnotatedClass = new MojoAnnotatedClass();
        this.mojoAnnotatedClass.setClassName(Type.getObjectType((String)name).getClassName());
        if (superName != null) {
            this.mojoAnnotatedClass.setParentClassName(Type.getObjectType((String)superName).getClassName());
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String annotationClassName = Type.getType((String)desc).getClassName();
        if (!MojoAnnotationsScanner.CLASS_LEVEL_ANNOTATIONS.contains(annotationClassName)) {
            return null;
        }
        if (annotationClassName.startsWith("org.apache.maven.api.plugin.annotations")) {
            this.mojoAnnotatedClass.setV4Api(true);
        }
        MojoAnnotationVisitor mojoAnnotationVisitor = new MojoAnnotationVisitor(annotationClassName);
        this.annotationVisitorMap.put(annotationClassName, mojoAnnotationVisitor);
        return mojoAnnotationVisitor;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        List<String> typeParameters = this.extractTypeParameters(access, signature, true);
        MojoFieldVisitor mojoFieldVisitor = new MojoFieldVisitor(name, Type.getType((String)desc).getClassName(), typeParameters);
        this.fieldVisitors.add(mojoFieldVisitor);
        return mojoFieldVisitor;
    }

    private List<String> extractTypeParameters(int access, String signature, boolean isField) {
        if (signature == null || signature.isEmpty()) {
            return Collections.emptyList();
        }
        TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(access);
        SignatureReader signatureReader = new SignatureReader(signature);
        if (isField) {
            signatureReader.acceptType((SignatureVisitor)traceSignatureVisitor);
        } else {
            signatureReader.accept((SignatureVisitor)traceSignatureVisitor);
        }
        String declaration = traceSignatureVisitor.getDeclaration();
        int startTypeParameters = declaration.indexOf(60);
        if (startTypeParameters == -1) {
            return Collections.emptyList();
        }
        String typeParameters = declaration.substring(startTypeParameters + 1, declaration.lastIndexOf(62));
        return Arrays.asList(typeParameters.split(", "));
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 1) != 1 || (access & 8) == 8) {
            return null;
        }
        if (name.length() < 4 || !name.startsWith("add") && !name.startsWith("set")) {
            return null;
        }
        Type type = Type.getType((String)desc);
        if ("void".equals(type.getReturnType().getClassName()) && type.getArgumentTypes().length == 1) {
            String fieldName = StringUtils.lowercaseFirstLetter((String)name.substring(3));
            String className = type.getArgumentTypes()[0].getClassName();
            List<String> typeParameters = this.extractTypeParameters(access, signature, false);
            MojoMethodVisitor mojoMethodVisitor = new MojoMethodVisitor(fieldName, className, typeParameters);
            this.methodVisitors.add(mojoMethodVisitor);
            return mojoMethodVisitor;
        }
        return null;
    }
}

