/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.testing.resources;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.TreeSet;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

@Deprecated
public class TestResources
extends TestWatcher {
    private final String projectsDir;
    private final String workDir;
    private String name;

    public TestResources() {
        this("src/test/projects", "target/test-projects");
    }

    public TestResources(String projectsDir, String workDir) {
        this.projectsDir = projectsDir;
        this.workDir = workDir;
    }

    protected void starting(Description d) {
        String methodName = d.getMethodName();
        if (methodName != null) {
            methodName = methodName.replace('/', '_').replace('\\', '_');
        }
        this.name = d.getTestClass().getSimpleName() + "_" + methodName;
    }

    public File getBasedir(String project) throws IOException {
        if (this.name == null) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " must be a test class field annotated with org.junit.Rule");
        }
        File src = new File(this.projectsDir, project).getCanonicalFile();
        Assert.assertTrue((String)("Test project directory does not exist: " + src.getPath()), (boolean)src.isDirectory());
        File basedir = new File(this.workDir, this.name + "_" + project).getCanonicalFile();
        FileUtils.deleteDirectory((File)basedir);
        Assert.assertTrue((String)"Test project working directory created", (boolean)basedir.mkdirs());
        FileUtils.copyDirectoryStructure((File)src, (File)basedir);
        return basedir;
    }

    public static void cp(File basedir, String from, String to) throws IOException {
        FileUtils.copyFile((File)new File(basedir, from), (File)new File(basedir, to));
    }

    public static void assertFileContents(File basedir, String expectedPath, String actualPath) throws IOException {
        String expected = FileUtils.fileRead((File)new File(basedir, expectedPath));
        String actual = FileUtils.fileRead((File)new File(basedir, actualPath));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertDirectoryContents(File dir, String ... expectedPaths) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        scanner.addDefaultExcludes();
        scanner.scan();
        TreeSet<String> actual = new TreeSet<String>();
        for (String path : scanner.getIncludedFiles()) {
            actual.add(path);
        }
        for (String path : scanner.getIncludedDirectories()) {
            if (path.length() <= 0) continue;
            actual.add(path + "/");
        }
        TreeSet<String> expected = new TreeSet<String>();
        if (expectedPaths != null) {
            for (String path : expectedPaths) {
                expected.add(path);
            }
        }
        Assert.assertEquals((Object)TestResources.toString(expected), (Object)TestResources.toString(actual));
    }

    private static String toString(Collection<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string).append('\n');
        }
        return sb.toString();
    }

    public static void touch(File basedir, String path) throws InterruptedException {
        TestResources.touch(new File(basedir, path));
    }

    public static void touch(File file) throws InterruptedException {
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a file " + file);
        }
        long lastModified = file.lastModified();
        file.setLastModified(System.currentTimeMillis());
        if (lastModified == file.lastModified()) {
            Thread.sleep(1000L);
            file.setLastModified(System.currentTimeMillis());
        }
    }

    public static void rm(File basedir, String path) {
        Assert.assertTrue((String)("delete " + path), (boolean)new File(basedir, path).delete());
    }

    public static void create(File basedir, String ... paths) throws IOException {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException();
        }
        for (String path : paths) {
            File file = new File(basedir, path);
            Assert.assertTrue((boolean)file.getParentFile().mkdirs());
            file.createNewFile();
            Assert.assertTrue((file.isFile() && file.canRead() ? 1 : 0) != 0);
        }
    }
}

