/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.xml;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

class ImmutableCollections {
    private static final Map<?, ?> EMPTY_MAP = new AbstractImmutableMap<Object, Object>(){

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return new AbstractImmutableSet<Map.Entry<Object, Object>>(){

                @Override
                public Iterator<Map.Entry<Object, Object>> iterator() {
                    return new Iterator<Map.Entry<Object, Object>>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public Map.Entry<Object, Object> next() {
                            throw new NoSuchElementException();
                        }
                    };
                }

                @Override
                public int size() {
                    return 0;
                }
            };
        }
    };

    ImmutableCollections() {
    }

    static <E1, E2 extends E1> List<E1> copy(Collection<E2> collection) {
        return collection == null ? List.of() : List.copyOf(collection);
    }

    static <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map == null) {
            return ImmutableCollections.emptyMap();
        }
        if (map instanceof AbstractImmutableMap) {
            return map;
        }
        switch (map.size()) {
            case 0: {
                return ImmutableCollections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                return ImmutableCollections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        return new MapN<K, V>(map);
    }

    static <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    static <K, V> Map<K, V> singletonMap(K key, V value) {
        return new Map1<K, V>(key, value);
    }

    private static UnsupportedOperationException uoe() {
        return new UnsupportedOperationException();
    }

    private static abstract class AbstractImmutableMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private AbstractImmutableMap() {
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V replace(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw ImmutableCollections.uoe();
        }
    }

    private static class MapN<K, V>
    extends AbstractImmutableMap<K, V> {
        private final Object[] entries;

        private MapN(Map<K, V> map) {
            if (map != null) {
                this.entries = new Object[map.size()];
                int idx = 0;
                for (Map.Entry<K, V> e : map.entrySet()) {
                    this.entries[idx++] = new AbstractMap.SimpleImmutableEntry<K, V>(e.getKey(), e.getValue());
                }
            } else {
                this.entries = new Object[0];
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractImmutableSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index < entries.length;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.index < entries.length) {
                                return (Map.Entry)entries[this.index++];
                            }
                            throw new NoSuchElementException();
                        }
                    };
                }

                @Override
                public int size() {
                    return entries.length;
                }
            };
        }
    }

    private static class Map1<K, V>
    extends AbstractImmutableMap<K, V> {
        private final Map.Entry<K, V> entry;

        private Map1(K key, V value) {
            this.entry = new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractImmutableSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index == 0;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.index++ == 0) {
                                return entry;
                            }
                            throw new NoSuchElementException();
                        }
                    };
                }

                @Override
                public int size() {
                    return 1;
                }
            };
        }
    }

    private static abstract class AbstractImmutableSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private AbstractImmutableSet() {
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean add(E e) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object o) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw ImmutableCollections.uoe();
        }
    }
}

