/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.maven.profiles.Activation;
import org.apache.maven.profiles.ActivationFile;
import org.apache.maven.profiles.ActivationProperty;
import org.apache.maven.profiles.Profile;
import org.apache.maven.profiles.ProfilesRoot;
import org.apache.maven.profiles.Repository;
import org.apache.maven.profiles.RepositoryBase;
import org.apache.maven.profiles.RepositoryPolicy;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ProfilesXpp3Writer {
    private XmlSerializer serializer;
    private String NAMESPACE;

    public void write(Writer writer, ProfilesRoot profilesXml) throws IOException {
        this.serializer = new MXSerializer();
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        this.serializer.setOutput(writer);
        this.writeProfilesRoot(profilesXml, "profilesXml", this.serializer);
    }

    private void writeActivation(Activation activation, String tagName, XmlSerializer serializer) throws IOException {
        if (activation != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activation.isActiveByDefault()) {
                serializer.startTag(this.NAMESPACE, "activeByDefault").text(String.valueOf(activation.isActiveByDefault())).endTag(this.NAMESPACE, "activeByDefault");
            }
            if (activation.getJdk() != null) {
                serializer.startTag(this.NAMESPACE, "jdk").text(activation.getJdk()).endTag(this.NAMESPACE, "jdk");
            }
            if (activation.getProperty() != null) {
                this.writeActivationProperty(activation.getProperty(), "property", serializer);
            }
            if (activation.getFile() != null) {
                this.writeActivationFile(activation.getFile(), "file", serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeActivationFile(ActivationFile activationFile, String tagName, XmlSerializer serializer) throws IOException {
        if (activationFile != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activationFile.getMissing() != null) {
                serializer.startTag(this.NAMESPACE, "missing").text(activationFile.getMissing()).endTag(this.NAMESPACE, "missing");
            }
            if (activationFile.getExists() != null) {
                serializer.startTag(this.NAMESPACE, "exists").text(activationFile.getExists()).endTag(this.NAMESPACE, "exists");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeActivationProperty(ActivationProperty activationProperty, String tagName, XmlSerializer serializer) throws IOException {
        if (activationProperty != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activationProperty.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(activationProperty.getName()).endTag(this.NAMESPACE, "name");
            }
            if (activationProperty.getValue() != null) {
                serializer.startTag(this.NAMESPACE, "value").text(activationProperty.getValue()).endTag(this.NAMESPACE, "value");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeProfile(Profile profile, String tagName, XmlSerializer serializer) throws IOException {
        if (profile != null) {
            Repository repository;
            Iterator<Object> iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (profile.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(profile.getId()).endTag(this.NAMESPACE, "id");
            }
            if (profile.getActivation() != null) {
                this.writeActivation(profile.getActivation(), "activation", serializer);
            }
            if (profile.getProperties() != null && ((Hashtable)profile.getProperties()).size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                iter = ((Hashtable)profile.getProperties()).keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)((Hashtable)profile.getProperties()).get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            if (profile.getRepositories() != null && profile.getRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "repositories");
                iter = profile.getRepositories().iterator();
                while (iter.hasNext()) {
                    repository = (Repository)iter.next();
                    this.writeRepository(repository, "repository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "repositories");
            }
            if (profile.getPluginRepositories() != null && profile.getPluginRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "pluginRepositories");
                iter = profile.getPluginRepositories().iterator();
                while (iter.hasNext()) {
                    repository = (Repository)iter.next();
                    this.writeRepository(repository, "pluginRepository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "pluginRepositories");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeProfilesRoot(ProfilesRoot profilesRoot, String tagName, XmlSerializer serializer) throws IOException {
        if (profilesRoot != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (profilesRoot.getProfiles() != null && profilesRoot.getProfiles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "profiles");
                iter = profilesRoot.getProfiles().iterator();
                while (iter.hasNext()) {
                    Profile profile = (Profile)iter.next();
                    this.writeProfile(profile, "profile", serializer);
                }
                serializer.endTag(this.NAMESPACE, "profiles");
            }
            if (profilesRoot.getActiveProfiles() != null && profilesRoot.getActiveProfiles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "activeProfiles");
                iter = profilesRoot.getActiveProfiles().iterator();
                while (iter.hasNext()) {
                    String activeProfile = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "activeProfile").text(activeProfile).endTag(this.NAMESPACE, "activeProfile");
                }
                serializer.endTag(this.NAMESPACE, "activeProfiles");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer) throws IOException {
        if (repository != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (repository.getSnapshotPolicy() != null) {
                serializer.startTag(this.NAMESPACE, "snapshotPolicy").text(repository.getSnapshotPolicy()).endTag(this.NAMESPACE, "snapshotPolicy");
            }
            if (repository.getChecksumPolicy() != null) {
                serializer.startTag(this.NAMESPACE, "checksumPolicy").text(repository.getChecksumPolicy()).endTag(this.NAMESPACE, "checksumPolicy");
            }
            if (repository.getReleases() != null) {
                this.writeRepositoryPolicy(repository.getReleases(), "releases", serializer);
            }
            if (repository.getSnapshots() != null) {
                this.writeRepositoryPolicy(repository.getSnapshots(), "snapshots", serializer);
            }
            if (repository.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(repository.getId()).endTag(this.NAMESPACE, "id");
            }
            if (repository.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(repository.getName()).endTag(this.NAMESPACE, "name");
            }
            if (repository.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(repository.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (repository.getLayout() != null && !repository.getLayout().equals("default")) {
                serializer.startTag(this.NAMESPACE, "layout").text(repository.getLayout()).endTag(this.NAMESPACE, "layout");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepositoryBase(RepositoryBase repositoryBase, String tagName, XmlSerializer serializer) throws IOException {
        if (repositoryBase != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (repositoryBase.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(repositoryBase.getId()).endTag(this.NAMESPACE, "id");
            }
            if (repositoryBase.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(repositoryBase.getName()).endTag(this.NAMESPACE, "name");
            }
            if (repositoryBase.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(repositoryBase.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (repositoryBase.getLayout() != null && !repositoryBase.getLayout().equals("default")) {
                serializer.startTag(this.NAMESPACE, "layout").text(repositoryBase.getLayout()).endTag(this.NAMESPACE, "layout");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepositoryPolicy(RepositoryPolicy repositoryPolicy, String tagName, XmlSerializer serializer) throws IOException {
        if (repositoryPolicy != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (!repositoryPolicy.isEnabled()) {
                serializer.startTag(this.NAMESPACE, "enabled").text(String.valueOf(repositoryPolicy.isEnabled())).endTag(this.NAMESPACE, "enabled");
            }
            if (repositoryPolicy.getUpdatePolicy() != null) {
                serializer.startTag(this.NAMESPACE, "updatePolicy").text(repositoryPolicy.getUpdatePolicy()).endTag(this.NAMESPACE, "updatePolicy");
            }
            if (repositoryPolicy.getChecksumPolicy() != null) {
                serializer.startTag(this.NAMESPACE, "checksumPolicy").text(repositoryPolicy.getChecksumPolicy()).endTag(this.NAMESPACE, "checksumPolicy");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

