/*
 * $Id$
 */

package org.apache.maven.plugin.lifecycle;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Root element of the lifecycle.xml file.
 * 
 * @version $Revision$ $Date$
 */
public class LifecycleConfiguration implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field lifecycles.
     */
    private java.util.List lifecycles;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addLifecycle.
     * 
     * @param lifecycle
     */
    public void addLifecycle( Lifecycle lifecycle )
    {
        if ( !(lifecycle instanceof Lifecycle) )
        {
            throw new ClassCastException( "LifecycleConfiguration.addLifecycles(lifecycle) parameter must be instanceof " + Lifecycle.class.getName() );
        }
        getLifecycles().add( lifecycle );
    } //-- void addLifecycle( Lifecycle ) 

    /**
     * Method getLifecycles.
     * 
     * @return java.util.List
     */
    public java.util.List getLifecycles()
    {
        if ( this.lifecycles == null )
        {
            this.lifecycles = new java.util.ArrayList();
        }
    
        return this.lifecycles;
    } //-- java.util.List getLifecycles() 

    /**
     * Method removeLifecycle.
     * 
     * @param lifecycle
     */
    public void removeLifecycle( Lifecycle lifecycle )
    {
        if ( !(lifecycle instanceof Lifecycle) )
        {
            throw new ClassCastException( "LifecycleConfiguration.removeLifecycles(lifecycle) parameter must be instanceof " + Lifecycle.class.getName() );
        }
        getLifecycles().remove( lifecycle );
    } //-- void removeLifecycle( Lifecycle ) 

    /**
     * Set the lifecycles field.
     * 
     * @param lifecycles
     */
    public void setLifecycles( java.util.List lifecycles )
    {
        this.lifecycles = lifecycles;
    } //-- void setLifecycles( java.util.List ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
