/*
 * $Id$
 */

package org.apache.maven.plugin.lifecycle;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         A custom lifecycle mapping definition.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Lifecycle implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field phases
     */
    private java.util.List phases;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPhase
     * 
     * @param phase
     */
    public void addPhase(Phase phase)
    {
        if ( !(phase instanceof Phase) )
        {
            throw new ClassCastException( "Lifecycle.addPhases(phase) parameter must be instanceof " + Phase.class.getName() );
        }
        getPhases().add( phase );
    } //-- void addPhase(Phase) 

    /**
     * Get The ID of this lifecycle, for identification in the mojo
     * descriptor.
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method getPhases
     */
    public java.util.List getPhases()
    {
        if ( this.phases == null )
        {
            this.phases = new java.util.ArrayList();
        }
        
        return this.phases;
    } //-- java.util.List getPhases() 

    /**
     * Method removePhase
     * 
     * @param phase
     */
    public void removePhase(Phase phase)
    {
        if ( !(phase instanceof Phase) )
        {
            throw new ClassCastException( "Lifecycle.removePhases(phase) parameter must be instanceof " + Phase.class.getName() );
        }
        getPhases().remove( phase );
    } //-- void removePhase(Phase) 

    /**
     * Set The ID of this lifecycle, for identification in the mojo
     * descriptor.
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set The phase mappings for this lifecycle.
     * 
     * @param phases
     */
    public void setPhases(java.util.List phases)
    {
        this.phases = phases;
    } //-- void setPhases(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
