/*
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 1.0.1 on 2009-07-22 22:32:06,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.model;

/**
 * Represents a set of reports and configuration to be used to
 * generate them.
 * 
 * @version $Revision$ $Date$
 */
public class ReportSet
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The unique id for this report set, to be used during POM
     * inheritance and profile injection
     *             for merging of report sets.
     *           
     */
    private String id = "default";

    /**
     * Configuration of the report to be used when generating this
     * set.
     */
    private Object configuration;

    /**
     * Whether any configuration should be propagated to child POMs.
     */
    private String inherited;

    /**
     * Field reports.
     */
    private java.util.List<String> reports;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addReport.
     * 
     * @param string
     */
    public void addReport( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ReportSet.addReports(string) parameter must be instanceof " + String.class.getName() );
        }
        getReports().add( string );
    } //-- void addReport( String )

    /**
     * Get configuration of the report to be used when generating
     * this set.
     * 
     * @return Object
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration()

    /**
     * Get the unique id for this report set, to be used during POM
     * inheritance and profile injection
     *             for merging of report sets.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId()

    /**
     * Get whether any configuration should be propagated to child
     * POMs.
     * 
     * @return String
     */
    public String getInherited()
    {
        return this.inherited;
    } //-- String getInherited()

    /**
     * Method getReports.
     * 
     * @return List
     */
    public java.util.List<String> getReports()
    {
        if ( this.reports == null )
        {
            this.reports = new java.util.ArrayList<String>();
        }

        return this.reports;
    } //-- java.util.List<String> getReports()

    /**
     * Method removeReport.
     * 
     * @param string
     */
    public void removeReport( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ReportSet.removeReports(string) parameter must be instanceof " + String.class.getName() );
        }
        getReports().remove( string );
    } //-- void removeReport( String )

    /**
     * Set configuration of the report to be used when generating
     * this set.
     * 
     * @param configuration
     */
    public void setConfiguration( Object configuration )
    {
        this.configuration = configuration;
    } //-- void setConfiguration( Object )

    /**
     * Set the unique id for this report set, to be used during POM
     * inheritance and profile injection
     *             for merging of report sets.
     * 
     * @param id
     */
    public void setId( String id )
    {
        this.id = id;
    } //-- void setId( String )

    /**
     * Set whether any configuration should be propagated to child
     * POMs.
     * 
     * @param inherited
     */
    public void setInherited( String inherited )
    {
        this.inherited = inherited;
    } //-- void setInherited( String )

    /**
     * Set the list of reports from this plugin which should be
     * generated from this set.
     * 
     * @param reports
     */
    public void setReports( java.util.List<String> reports )
    {
        this.reports = reports;
    } //-- void setReports( java.util.List )


            
    private boolean inheritanceApplied = true;

    public void unsetInheritanceApplied()
    {
        this.inheritanceApplied = false;
    }

    public boolean isInheritanceApplied()
    {
        return inheritanceApplied;
    }

    @Override
    public String toString()
    {
        return getId();
    }
            
          
}
