/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.merge.MavenModelMerger;
import org.apache.maven.model.profile.ProfileInjector;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ProfileInjector.class)
public class DefaultProfileInjector
implements ProfileInjector {
    private ProfileModelMerger merger = new ProfileModelMerger();

    public void injectProfile(Model model, Profile profile, ModelBuildingRequest request, ModelProblemCollector problems) {
        if (profile != null) {
            this.merger.mergeModelBase((ModelBase)model, (ModelBase)profile);
            if (profile.getBuild() != null) {
                if (model.getBuild() == null) {
                    model.setBuild(new Build());
                }
                this.merger.mergeBuildBase((BuildBase)model.getBuild(), profile.getBuild());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProfileModelMerger
    extends MavenModelMerger {
        private ProfileModelMerger() {
        }

        public void mergeModelBase(ModelBase target, ModelBase source) {
            this.mergeModelBase(target, source, true, Collections.emptyMap());
        }

        public void mergeBuildBase(BuildBase target, BuildBase source) {
            this.mergeBuildBase(target, source, true, Collections.emptyMap());
        }

        protected void mergePluginContainer_Plugins(PluginContainer target, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                Object key;
                List tgt = target.getPlugins();
                LinkedHashMap<Object, Plugin> merged = new LinkedHashMap<Object, Plugin>((src.size() + tgt.size()) * 2);
                for (Plugin element : tgt) {
                    key = this.getPluginKey(element);
                    merged.put(key, element);
                }
                for (Plugin element : src) {
                    key = this.getPluginKey(element);
                    Plugin existing = (Plugin)merged.get(key);
                    if (existing == null) {
                        merged.put(key, element);
                        continue;
                    }
                    this.mergePlugin(existing, element, sourceDominant, context);
                }
                target.setPlugins(new ArrayList(merged.values()));
            }
        }

        protected void mergeReporting_Plugins(Reporting target, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                Object key;
                List tgt = target.getPlugins();
                LinkedHashMap<Object, ReportPlugin> merged = new LinkedHashMap<Object, ReportPlugin>((src.size() + tgt.size()) * 2);
                for (ReportPlugin element : tgt) {
                    key = this.getReportPluginKey(element);
                    merged.put(key, element);
                }
                for (ReportPlugin element : src) {
                    key = this.getReportPluginKey(element);
                    ReportPlugin existing = (ReportPlugin)merged.get(key);
                    if (existing == null) {
                        merged.put(key, element);
                        continue;
                    }
                    this.mergeReportPlugin(existing, element, sourceDominant, context);
                }
                target.setPlugins(new ArrayList(merged.values()));
            }
        }
    }
}

