/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;

public class DefaultModelProblem
implements ModelProblem {
    private final String source;
    private final String message;
    private final Exception exception;
    private final ModelProblem.Severity severity;

    public DefaultModelProblem(String message, ModelProblem.Severity severity, Model source) {
        this(message, severity, ModelProblemUtils.toSourceHint(source), null);
    }

    public DefaultModelProblem(String message, ModelProblem.Severity severity, String source) {
        this(message, severity, source, null);
    }

    public DefaultModelProblem(String message, ModelProblem.Severity severity, String source, Exception exception) {
        this.message = message;
        this.severity = severity != null ? severity : ModelProblem.Severity.ERROR;
        this.source = source != null ? source : "";
        this.exception = exception;
    }

    public String getSource() {
        return this.source;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getMessage() {
        String msg;
        if (this.message != null && this.message.length() > 0) {
            msg = this.message;
        } else {
            msg = this.exception.getMessage();
            if (msg == null) {
                msg = "";
            }
        }
        return msg;
    }

    public ModelProblem.Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("[").append((Object)this.getSeverity()).append("] ");
        buffer.append(this.getSource()).append(": ").append(this.getMessage());
        return buffer.toString();
    }
}

