package org.apache.maven.model.management;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;

/**
 * Handles injection of plugin management into the model.
 * 
 * @author Benjamin Bentmann
 */
public interface PluginManagementInjector
{

    /**
     * Merges default values from the plugin management section of the given model into itself.
     * 
     * @param child The model into which to merge the values specified by its plugin management section, must not be
     *            <code>null</code>.
     * @param request The model building request that holds further settings, must not be {@code null}.
     * @param problems The container used to collect problems that were encountered, must not be {@code null}.
     */
    void injectManagement( Model child, ModelBuildingRequest request, ModelProblemCollector problems );

    /**
     * Merges important default values from the plugin management section of the given model into itself. In detail,
     * only the plugin version and the extensions flag are merged. These fields are critical in order to be able to load
     * extensions from plugins.
     * 
     * @param child The model into which to merge the values specified by its plugin management section, must not be
     *            <code>null</code>.
     * @param request The model building request that holds further settings, must not be {@code null}.
     * @param problems The container used to collect problems that were encountered, must not be {@code null}.
     */
    void injectBasicManagement( Model child, ModelBuildingRequest request, ModelProblemCollector problems );

}
