/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.building.ModelProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBuildingException
extends Exception {
    private final List<ModelProblem> problems = new ArrayList<ModelProblem>();

    public ModelBuildingException(List<ModelProblem> problems) {
        super(ModelBuildingException.toMessage(problems));
        if (problems != null) {
            this.problems.addAll(problems);
        }
    }

    public List<ModelProblem> getProblems() {
        return this.problems;
    }

    private static String toMessage(List<ModelProblem> problems) {
        StringWriter buffer = new StringWriter(1024);
        PrintWriter writer = new PrintWriter(buffer);
        writer.print(problems.size());
        writer.print(problems.size() == 1 ? " problem was " : " problems were ");
        writer.println("encountered during construction of the effective model:");
        for (ModelProblem problem : problems) {
            writer.print("o ");
            writer.println(problem.getMessage());
        }
        return buffer.toString();
    }
}

