/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileActivationException;
import org.apache.maven.model.profile.ProfileSelectionResult;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ProfileSelector.class)
public class DefaultProfileSelector
implements ProfileSelector {
    @Requirement(role=ProfileActivator.class)
    private List<ProfileActivator> activators;

    @Override
    public ProfileSelectionResult getActiveProfiles(Collection<Profile> profiles, ProfileActivationContext context) {
        HashSet<String> activatedIds = new HashSet<String>(context.getActiveProfileIds());
        HashSet<String> deactivatedIds = new HashSet<String>(context.getInactiveProfileIds());
        ArrayList<Profile> activeProfiles = new ArrayList<Profile>(profiles.size());
        ArrayList<Profile> activePomProfilesByDefault = new ArrayList<Profile>();
        boolean activatedPomProfileNotByDefault = false;
        ArrayList<ProfileActivationException> activationExceptions = new ArrayList<ProfileActivationException>();
        for (Profile profile : profiles) {
            if (deactivatedIds.contains(profile.getId())) continue;
            if (activatedIds.contains(profile.getId()) || this.isActive(profile, context, activationExceptions)) {
                activeProfiles.add(profile);
                if (!"pom".equals(profile.getSource())) continue;
                activatedPomProfileNotByDefault = true;
                continue;
            }
            if (!this.isActiveByDefault(profile)) continue;
            if ("pom".equals(profile.getSource())) {
                activePomProfilesByDefault.add(profile);
                continue;
            }
            activeProfiles.add(profile);
        }
        if (!activatedPomProfileNotByDefault) {
            activeProfiles.addAll(activePomProfilesByDefault);
        }
        ProfileSelectionResult result = new ProfileSelectionResult();
        result.setActiveProfiles(activeProfiles);
        result.setActivationExceptions(activationExceptions);
        return result;
    }

    private boolean isActive(Profile profile, ProfileActivationContext context, List<ProfileActivationException> exceptions) {
        for (ProfileActivator activator : this.activators) {
            try {
                if (!activator.isActive(profile, context)) continue;
                return true;
            }
            catch (ProfileActivationException e) {
                exceptions.add(e);
            }
        }
        return false;
    }

    private boolean isActiveByDefault(Profile profile) {
        Activation activation = profile.getActivation();
        return activation != null && activation.isActiveByDefault();
    }
}

