/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.plugin;

import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.plugin.PluginConfigurationExpander;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=PluginConfigurationExpander.class)
public class DefaultPluginConfigurationExpander
implements PluginConfigurationExpander {
    public void expandPluginConfiguration(Model model, ModelBuildingRequest request) {
        Xpp3Dom childDom;
        Xpp3Dom parentDom;
        Build build = model.getBuild();
        Reporting reporting = model.getReporting();
        if (build != null) {
            for (Plugin buildPlugin : build.getPlugins()) {
                parentDom = (Xpp3Dom)buildPlugin.getConfiguration();
                if (parentDom == null) continue;
                for (PluginExecution execution : buildPlugin.getExecutions()) {
                    childDom = (Xpp3Dom)execution.getConfiguration();
                    childDom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childDom, (Xpp3Dom)new Xpp3Dom(parentDom));
                    execution.setConfiguration((Object)childDom);
                }
            }
        }
        if (reporting != null) {
            for (ReportPlugin reportPlugin : reporting.getPlugins()) {
                parentDom = (Xpp3Dom)reportPlugin.getConfiguration();
                if (parentDom == null) continue;
                for (PluginExecution execution : reportPlugin.getReportSets()) {
                    childDom = (Xpp3Dom)execution.getConfiguration();
                    childDom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childDom, (Xpp3Dom)new Xpp3Dom(parentDom));
                    execution.setConfiguration((Object)childDom);
                }
            }
        }
    }
}

