/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.merge;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Extension;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.apache.maven.model.merge.ModelMerger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenModelMerger
extends ModelMerger {
    public static final String CHILD_PATH_ADJUSTMENT = "child-path-adjustment";
    private static final String ARTIFACT_ID = "artifact-id";

    protected void mergeModel(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        context.put(ARTIFACT_ID, target.getArtifactId());
        super.mergeModel(target, source, sourceDominant, context);
    }

    protected void mergeModel_Name(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        if (src != null && sourceDominant) {
            target.setName(src);
        }
    }

    protected void mergeModel_Url(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        if (src != null) {
            if (sourceDominant) {
                target.setUrl(src);
            } else if (target.getUrl() == null) {
                target.setUrl(this.appendPath(src, context.get(ARTIFACT_ID).toString(), context.get(CHILD_PATH_ADJUSTMENT).toString()));
            }
        }
    }

    protected void mergeModel_Organization(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        Organization tgt;
        Organization src = source.getOrganization();
        if (source.getOrganization() != null && (tgt = target.getOrganization()) == null) {
            tgt = new Organization();
            target.setOrganization(tgt);
            this.mergeOrganization(tgt, src, sourceDominant, context);
        }
    }

    protected void mergeModel_IssueManagement(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        IssueManagement tgt;
        IssueManagement src = source.getIssueManagement();
        if (source.getIssueManagement() != null && (tgt = target.getIssueManagement()) == null) {
            tgt = new IssueManagement();
            target.setIssueManagement(tgt);
            this.mergeIssueManagement(tgt, src, sourceDominant, context);
        }
    }

    protected void mergeModel_CiManagement(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        CiManagement tgt;
        CiManagement src = source.getCiManagement();
        if (source.getCiManagement() != null && (tgt = target.getCiManagement()) == null) {
            tgt = new CiManagement();
            target.setCiManagement(tgt);
            this.mergeCiManagement(tgt, src, sourceDominant, context);
        }
    }

    protected void mergeModel_Profiles(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
    }

    protected void mergeModel_Prerequisites(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
    }

    protected void mergeModel_Licenses(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        if (target.getLicenses().isEmpty()) {
            target.setLicenses(new ArrayList(source.getLicenses()));
        }
    }

    protected void mergeModel_Developers(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        if (target.getDevelopers().isEmpty()) {
            target.setDevelopers(new ArrayList(source.getDevelopers()));
        }
    }

    protected void mergeModel_Contributors(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        if (target.getContributors().isEmpty()) {
            target.setContributors(new ArrayList(source.getContributors()));
        }
    }

    protected void mergeModel_MailingLists(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        if (target.getMailingLists().isEmpty()) {
            target.setMailingLists(new ArrayList(source.getMailingLists()));
        }
    }

    protected void mergeModelBase_Modules(ModelBase target, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getModules();
        if (!src.isEmpty() && sourceDominant) {
            List tgt = target.getModules();
            LinkedHashSet excludes = new LinkedHashSet(tgt);
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src.size());
            merged.addAll(tgt);
            for (String s : src) {
                if (excludes.contains(s)) continue;
                merged.add(s);
            }
            target.setModules(merged);
        }
    }

    protected void mergeModelBase_Repositories(ModelBase target, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getRepositories();
        if (!src.isEmpty()) {
            Object key;
            List recessive;
            List dominant;
            List tgt = target.getRepositories();
            LinkedHashMap<Object, Repository> merged = new LinkedHashMap<Object, Repository>((src.size() + tgt.size()) * 2);
            if (sourceDominant) {
                dominant = src;
                recessive = tgt;
            } else {
                dominant = tgt;
                recessive = src;
            }
            for (Repository element : dominant) {
                key = this.getRepositoryKey(element);
                merged.put(key, element);
            }
            for (Repository element : recessive) {
                key = this.getRepositoryKey(element);
                if (merged.containsKey(key)) continue;
                merged.put(key, element);
            }
            target.setRepositories(new ArrayList(merged.values()));
        }
    }

    protected void mergeBuildBase_Filters(BuildBase target, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getFilters();
        if (!src.isEmpty()) {
            List tgt = target.getFilters();
            LinkedHashSet excludes = new LinkedHashSet(tgt);
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src.size());
            merged.addAll(tgt);
            for (String s : src) {
                if (excludes.contains(s)) continue;
                merged.add(s);
            }
            target.setFilters(merged);
        }
    }

    protected void mergeBuildBase_Resources(BuildBase target, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant || target.getResources().isEmpty()) {
            super.mergeBuildBase_Resources(target, source, sourceDominant, context);
        }
    }

    protected void mergeBuildBase_TestResources(BuildBase target, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant || target.getTestResources().isEmpty()) {
            super.mergeBuildBase_TestResources(target, source, sourceDominant, context);
        }
    }

    protected void mergeDistributionManagement_Repository(DistributionManagement target, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        DeploymentRepository tgt;
        DeploymentRepository src = source.getRepository();
        if (src != null && (tgt = target.getRepository()) == null) {
            tgt = new DeploymentRepository();
            target.setRepository(tgt);
            this.mergeDeploymentRepository(tgt, src, sourceDominant, context);
        }
    }

    protected void mergeDistributionManagement_SnapshotRepository(DistributionManagement target, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        DeploymentRepository tgt;
        DeploymentRepository src = source.getSnapshotRepository();
        if (src != null && (tgt = target.getSnapshotRepository()) == null) {
            tgt = new DeploymentRepository();
            target.setSnapshotRepository(tgt);
            this.mergeDeploymentRepository(tgt, src, sourceDominant, context);
        }
    }

    protected void mergeDistributionManagement_Site(DistributionManagement target, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        Site tgt;
        Site src = source.getSite();
        if (src != null && (tgt = target.getSite()) == null) {
            tgt = new Site();
            target.setSite(tgt);
            this.mergeSite(tgt, src, sourceDominant, context);
        }
    }

    protected void mergeSite_Url(Site target, Site source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        if (src != null) {
            if (sourceDominant) {
                target.setUrl(src);
            } else if (target.getUrl() == null) {
                target.setUrl(this.appendPath(src, context.get(ARTIFACT_ID).toString(), context.get(CHILD_PATH_ADJUSTMENT).toString()));
            }
        }
    }

    protected void mergeScm_Url(Scm target, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        if (src != null) {
            if (sourceDominant) {
                target.setUrl(src);
            } else if (target.getUrl() == null) {
                target.setUrl(this.appendPath(src, context.get(ARTIFACT_ID).toString(), context.get(CHILD_PATH_ADJUSTMENT).toString()));
            }
        }
    }

    protected void mergeScm_Connection(Scm target, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getConnection();
        if (src != null) {
            if (sourceDominant) {
                target.setConnection(src);
            } else if (target.getConnection() == null) {
                target.setConnection(this.appendPath(src, context.get(ARTIFACT_ID).toString(), context.get(CHILD_PATH_ADJUSTMENT).toString()));
            }
        }
    }

    protected void mergeScm_DeveloperConnection(Scm target, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getDeveloperConnection();
        if (src != null) {
            if (sourceDominant) {
                target.setDeveloperConnection(src);
            } else if (target.getDeveloperConnection() == null) {
                target.setDeveloperConnection(this.appendPath(src, context.get(ARTIFACT_ID).toString(), context.get(CHILD_PATH_ADJUSTMENT).toString()));
            }
        }
    }

    protected void mergePlugin_Executions(Plugin target, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getExecutions();
        if (!src.isEmpty()) {
            Object key;
            List tgt = target.getExecutions();
            LinkedHashMap<Object, PluginExecution> merged = new LinkedHashMap<Object, PluginExecution>((src.size() + tgt.size()) * 2);
            for (PluginExecution element : src) {
                if (!sourceDominant && (!source.isInherited() || !element.isInherited())) continue;
                key = this.getPluginExecutionKey(element);
                merged.put(key, element);
            }
            for (PluginExecution element : tgt) {
                key = this.getPluginExecutionKey(element);
                PluginExecution existing = (PluginExecution)merged.get(key);
                if (existing != null) {
                    this.mergePluginExecution(element, existing, sourceDominant, context);
                }
                merged.put(key, element);
            }
            target.setExecutions(new ArrayList(merged.values()));
        }
    }

    protected void mergePluginExecution_Goals(PluginExecution target, PluginExecution source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getGoals();
        if (!src.isEmpty()) {
            List tgt = target.getGoals();
            LinkedHashSet excludes = new LinkedHashSet(tgt);
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src.size());
            merged.addAll(tgt);
            for (String s : src) {
                if (excludes.contains(s)) continue;
                merged.add(s);
            }
            target.setGoals(merged);
        }
    }

    protected Object getDependencyKey(Dependency dependency) {
        return dependency.getManagementKey();
    }

    protected Object getPluginKey(Plugin object) {
        return object.getKey();
    }

    protected Object getPluginExecutionKey(PluginExecution object) {
        return object.getId();
    }

    protected Object getReportPluginKey(ReportPlugin object) {
        return object.getKey();
    }

    protected Object getReportSetKey(ReportSet object) {
        return object.getId();
    }

    protected Object getRepositoryBaseKey(RepositoryBase object) {
        return object.getId();
    }

    protected Object getExtensionKey(Extension object) {
        return object.getGroupId() + ':' + object.getArtifactId();
    }

    private String appendPath(String parentPath, String childPath, String pathAdjustment) {
        String uncleanPath = parentPath;
        if (pathAdjustment != null && pathAdjustment.length() > 0) {
            uncleanPath = uncleanPath + "/" + pathAdjustment;
        }
        if (childPath != null) {
            uncleanPath = uncleanPath + "/" + childPath;
        }
        String cleanedPath = "";
        int protocolIdx = uncleanPath.indexOf("://");
        if (protocolIdx > -1) {
            cleanedPath = uncleanPath.substring(0, protocolIdx + 3);
            uncleanPath = uncleanPath.substring(protocolIdx + 3);
        }
        if (uncleanPath.startsWith("//")) {
            cleanedPath = cleanedPath + "//";
        } else if (uncleanPath.startsWith("/")) {
            cleanedPath = cleanedPath + "/";
        }
        return cleanedPath + this.resolvePath(uncleanPath);
    }

    private String resolvePath(String uncleanPath) {
        LinkedList<String> pathElements = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(uncleanPath, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("")) continue;
            if (token.equals("..")) {
                if (pathElements.isEmpty()) continue;
                pathElements.removeLast();
                continue;
            }
            pathElements.addLast(token);
        }
        StringBuffer cleanedPath = new StringBuffer();
        while (!pathElements.isEmpty()) {
            cleanedPath.append((String)pathElements.removeFirst());
            if (pathElements.isEmpty()) continue;
            cleanedPath.append('/');
        }
        return cleanedPath.toString();
    }
}

