/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.resolver.type;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.Language;
import org.apache.maven.api.PathType;
import org.apache.maven.api.Type;
import org.eclipse.aether.artifact.ArtifactType;

public class DefaultType
implements Type,
ArtifactType {
    private final String id;
    private final Language language;
    private final String extension;
    private final String classifier;
    private final boolean includesDependencies;
    private final Set<PathType> pathTypes;
    private final Map<String, String> properties;

    public DefaultType(String id, Language language, String extension, String classifier, boolean includesDependencies, PathType ... pathTypes) {
        this.id = Objects.requireNonNull(id, "id");
        this.language = Objects.requireNonNull(language, "language");
        this.extension = Objects.requireNonNull(extension, "extension");
        this.classifier = classifier;
        this.includesDependencies = includesDependencies;
        this.pathTypes = Collections.unmodifiableSet(new HashSet<PathType>(Arrays.asList(pathTypes)));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("type", id);
        properties.put("language", language.id());
        properties.put("includesDependencies", Boolean.toString(includesDependencies));
        properties.put("constitutesBuildPath", String.valueOf(this.pathTypes.contains(JavaPathType.CLASSES)));
        this.properties = Collections.unmodifiableMap(properties);
    }

    public String id() {
        return this.id;
    }

    public String getId() {
        return this.id();
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean isIncludesDependencies() {
        return this.includesDependencies;
    }

    public Set<PathType> getPathTypes() {
        return this.pathTypes;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "DefaultType[id='" + this.id + "', language=" + this.language + ", extension='" + this.extension + "', classifier='" + this.classifier + "', includesDependencies=" + this.includesDependencies + ", pathTypes=" + this.pathTypes + ", properties=" + this.properties + "]";
    }
}

