/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.di.Key;
import org.apache.maven.di.Scope;
import org.apache.maven.di.impl.Types;
import org.apache.maven.impl.di.OutOfScopeException;

public class SessionScope
implements Scope {
    protected final List<ScopeState> values = new CopyOnWriteArrayList<ScopeState>();

    public void enter() {
        this.values.add(0, new ScopeState());
    }

    protected ScopeState getScopeState() {
        if (this.values.isEmpty()) {
            throw new OutOfScopeException("Cannot access session scope outside of a scoping block");
        }
        return this.values.get(0);
    }

    public void exit() {
        if (this.values.isEmpty()) {
            throw new IllegalStateException();
        }
        this.values.remove(0);
    }

    public <T> void seed(Class<T> clazz, Supplier<T> value) {
        this.getScopeState().seed(clazz, value);
    }

    public <T> void seed(Class<T> clazz, T value) {
        this.seed(clazz, (T)((Supplier<Object>)() -> value));
    }

    @Nonnull
    public <T> Supplier<T> scope(@Nonnull Key<T> key, @Nonnull Supplier<T> unscoped) {
        return () -> {
            if (this.values.isEmpty()) {
                return this.createProxy(key, unscoped);
            }
            return this.getScopeState().scope(key, unscoped).get();
        };
    }

    protected <T> T createProxy(Key<T> key, Supplier<T> unscoped) {
        InvocationHandler dispatcher = (proxy, method, args) -> this.dispatch(key, unscoped, method, args);
        Class superType = Types.getRawType((Type)key.getType());
        Class<?>[] interfaces = this.getInterfaces(superType);
        return (T)Proxy.newProxyInstance(superType.getClassLoader(), interfaces, dispatcher);
    }

    protected <T> Object dispatch(Key<T> key, Supplier<T> unscoped, Method method, Object[] args) throws Throwable {
        method.setAccessible(true);
        try {
            return method.invoke(this.getScopeState().scope(key, unscoped).get(), args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    protected Class<?>[] getInterfaces(Class<?> superType) {
        if (superType.isInterface()) {
            return new Class[]{superType};
        }
        for (Annotation a : superType.getAnnotations()) {
            Class<? extends Annotation> annotationType = a.annotationType();
            if (!this.isTypeAnnotation(annotationType)) continue;
            try {
                List<Class> nonInterfaces;
                Class[] value = (Class[])annotationType.getMethod("value", new Class[0]).invoke((Object)a, new Object[0]);
                if (value.length == 0) {
                    value = superType.getInterfaces();
                }
                if (!(nonInterfaces = Stream.of(value).filter(c -> !c.isInterface()).toList()).isEmpty()) {
                    throw new IllegalArgumentException("The Typed annotation must contain only interfaces but the following types are not: " + nonInterfaces);
                }
                return value;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalArgumentException("The use of session scoped proxies require a org.eclipse.sisu.Typed or javax.enterprise.inject.Typed annotation");
    }

    protected boolean isTypeAnnotation(Class<? extends Annotation> annotationType) {
        return "org.apache.maven.api.di.Typed".equals(annotationType.getName());
    }

    public static <T> Supplier<T> seededKeySupplier(Class<? extends T> clazz) {
        return () -> {
            throw new IllegalStateException("No instance of " + clazz.getName() + " is bound to the session scope.");
        };
    }

    protected static final class ScopeState {
        private final Map<Key<?>, CachingProvider<?>> provided = new ConcurrentHashMap();

        protected ScopeState() {
        }

        public <T> void seed(Class<T> clazz, Supplier<T> value) {
            this.provided.put(Key.of(clazz), new CachingProvider<T>(value));
        }

        public <T> Supplier<T> scope(Key<T> key, Supplier<T> unscoped) {
            Supplier provider = this.provided.computeIfAbsent(key, k -> new CachingProvider(unscoped));
            return provider;
        }

        public Collection<CachingProvider<?>> providers() {
            return this.provided.values();
        }
    }

    protected static class CachingProvider<T>
    implements Supplier<T> {
        private final Supplier<T> provider;
        private volatile T value;

        CachingProvider(Supplier<T> provider) {
            this.provider = provider;
        }

        public T value() {
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.value == null) {
                CachingProvider cachingProvider = this;
                synchronized (cachingProvider) {
                    if (this.value == null) {
                        this.value = this.provider.get();
                    }
                }
            }
            return this.value;
        }
    }
}

