/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.ExtensibleEnum;
import org.apache.maven.api.Language;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.SessionScoped;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ExtensibleEnumRegistry;
import org.apache.maven.api.services.LanguageRegistry;
import org.apache.maven.api.services.PathScopeRegistry;
import org.apache.maven.api.services.ProjectScopeRegistry;
import org.apache.maven.api.spi.ExtensibleEnumProvider;
import org.apache.maven.api.spi.LanguageProvider;
import org.apache.maven.api.spi.PathScopeProvider;
import org.apache.maven.api.spi.ProjectScopeProvider;
import org.apache.maven.impl.ImplUtils;

public class ExtensibleEnumRegistries {

    public static abstract class DefaultExtensibleEnumRegistry<T extends ExtensibleEnum, P extends ExtensibleEnumProvider<T>>
    implements ExtensibleEnumRegistry<T> {
        protected final Map<String, T> values;

        public DefaultExtensibleEnumRegistry(List<P> providers, T ... builtinValues) {
            this.values = Stream.concat(Stream.of(builtinValues), providers.stream().flatMap(p -> p.provides().stream())).collect(Collectors.toUnmodifiableMap(t -> t.id().toLowerCase(Locale.ROOT), t -> t));
        }

        public Optional<T> lookup(String id) {
            return Optional.ofNullable((ExtensibleEnum)this.values.get(ImplUtils.nonNull(id, "id").toLowerCase(Locale.ROOT)));
        }
    }

    @Named
    @Singleton
    public static class DefaultLanguageRegistry
    extends DefaultExtensibleEnumRegistry<Language, LanguageProvider>
    implements LanguageRegistry {
        @Inject
        public DefaultLanguageRegistry(List<LanguageProvider> providers) {
            super(providers, (ExtensibleEnum[])new Language[]{Language.NONE, Language.RESOURCES, Language.SCRIPT, Language.JAVA_FAMILY});
        }
    }

    @Named
    @SessionScoped
    public static class DefaultProjectScopeRegistry
    extends DefaultExtensibleEnumRegistry<ProjectScope, ProjectScopeProvider>
    implements ProjectScopeRegistry {
        @Inject
        public DefaultProjectScopeRegistry(List<ProjectScopeProvider> providers) {
            super(providers, (ExtensibleEnum[])new ProjectScope[]{ProjectScope.MAIN, ProjectScope.TEST});
        }
    }

    @Named
    @SessionScoped
    public static class DefaultPathScopeRegistry
    extends DefaultExtensibleEnumRegistry<PathScope, PathScopeProvider>
    implements PathScopeRegistry {
        @Inject
        public DefaultPathScopeRegistry(List<PathScopeProvider> providers) {
            super(providers, (ExtensibleEnum[])new PathScope[]{PathScope.MAIN_COMPILE, PathScope.MAIN_RUNTIME, PathScope.TEST_COMPILE, PathScope.TEST_RUNTIME});
        }
    }
}

